// Copyright 1998-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAPopUpButton.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OATypeAheadSelectionHelper.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAPopUpButton.m,v 1.12 2001/11/05 21:01:17 kc Exp $")

@interface OAPopUpButton (PrivateAPI)
- (void)_updateLabel;
@end

@implementation OAPopUpButton

- (id)initWithCoder:(NSCoder *)coder;
{
    if (!(self = [super initWithCoder:coder]))
        return nil;

    // we don't currently archive the label field since this object isn't palettized.
    // rather, IB encodes a connector and manually sets the ivar
    //label = [[coder decodeObject] retain];
    if (label)
        [self _updateLabel];

    return self;
}


// NSResponder subclass

- (void)keyDown:(NSEvent *)theEvent;
{
    NSString *characters;
    unichar firstCharacter;
    unsigned int modifierFlags;

    characters = [theEvent characters];
    modifierFlags = [theEvent modifierFlags];
    firstCharacter = [characters characterAtIndex:0];

    // See if there's an item whose title matches what the user is typing.
    // This can only be activated, initially, by typing an alphanumeric character.  This means it's smart enough to know when the user is, say, pressing space to page down, or pressing space separating two search string words. Should this still apply here?
    if (![[NSUserDefaults standardUserDefaults] boolForKey:@"DisableTypeAheadSelection"] && ([[NSCharacterSet alphanumericCharacterSet] characterIsMember:firstCharacter] || ([typeAheadHelper isProcessing] && ![[NSCharacterSet controlCharacterSet] characterIsMember:firstCharacter]))) {
        if (typeAheadHelper == nil) {
            typeAheadHelper = [[OATypeAheadSelectionHelper alloc] init];
            [typeAheadHelper setDataSource:self];
        }
        
        [typeAheadHelper processKeyDownCharacter:firstCharacter];
        return;
    }
    
    [super keyDown:theEvent];
}

// NSControl subclass

- (void)setEnabled:(BOOL)isEnabled;
{
    [super setEnabled:isEnabled];
    if (label)
        [self _updateLabel];
}

@end

@implementation OAPopUpButton (NotificationsDelegatesDataSources)

// OATypeAheadSelectionDataSource (cakewalk)

- (NSArray *)typeAheadSelectionItems;
{
    return [self itemTitles];
}

- (NSString *)currentlySelectedItem;
{
    return [self titleOfSelectedItem];
}

- (void)typeAheadSelectItemAtIndex:(int)itemIndex;
{
    [self selectItemAtIndex:itemIndex];
    [self sendAction:[self action] to:[self target]];
}

@end

@implementation OAPopUpButton (PrivateAPI)

- (void)_updateLabel;
{
    NSColor *color;

    if ([self isEnabled]) {
        color = [NSColor controlTextColor];
    } else {
        color = [NSColor disabledControlTextColor];
    }

    [label setTextColor:color];
}

@end
