// Copyright 2000-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniExpat/OmniExpat.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniExpat/Tests/xml2plist/xml2plist_main.m,v 1.4 2002/03/09 01:53:59 kc Exp $")

int main(int argc, const char *argv[])
{
    NSAutoreleasePool *pool;
    NSString *xmlFile;
    NSDictionary *propertyList;

    pool = [[NSAutoreleasePool alloc] init];
    if (argc < 2) {
        fprintf(stderr, "usage: %s file\n", argv[0]);
        exit(-1);
    }

    [OBPostLoader processClasses];
    
    xmlFile = [NSString stringWithContentsOfFile:[NSString stringWithCString:argv[1]]];
    propertyList = [xmlFile propertyListFromXMLFormat];

    NSLog(@"Property List:\n %@", propertyList);

    [pool release];
    return 0;
}
