// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFTPServer/OFTPConnection.h,v 1.4 2000/11/02 18:45:21 toon Exp $

#import <Foundation/Foundation.h>
#import "OFTPDelegate.h"

@class ONSocketStream;
@class ONTCPSocket;
@class ONHostAddress;

@interface OFTPConnection : NSObject
{
    ONSocketStream *stream;
    ONHostAddress *dataAddress;
    unsigned int dataPort;
    ONTCPSocket *passiveSocket;
    id <OFTPDelegate, NSObject> delegate;
    NSString *userName;
    NSString *currentWorkingDirectory;
}

- initWithSocket:(ONTCPSocket *)aSocket
     andDelegate:(id <OFTPDelegate, NSObject>)aDelegate;

- (void)processConnection;

@end
