// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//

#import "OFTPConnection.h"
#import <OmniNetworking/OmniNetworking.h>

@implementation OFTPConnection

- initWithSocket:(ONTCPSocket *)aSocket
     andDelegate:(id <OFTPDelegate, NSObject>)aDelegate;
{
    [super init];
    delegate = [aDelegate retain];
    stream = [[ONSocketStream alloc] initWithSocket:aSocket];
    return self;
}

- (ONTCPSocket *)openDataConnection;
{
    ONTCPSocket *dataSocket;

    if (passiveSocket) {
        dataSocket = passiveSocket;
        passiveSocket = nil;
        [dataSocket acceptConnection];
        [dataSocket autorelease];
    } else {
        if (!dataAddress) {
            [stream writeString:@"425 Can't open data connection.\r\n"];
            return nil;
        }
        dataSocket = [ONTCPSocket tcpSocket];
        [dataSocket connectToAddress:dataAddress port:dataPort];
    }
    return dataSocket;
}

- (void)processConnection;
{
    NSAutoreleasePool *pool;
    NSString *command, *arguments;
    NSRange range;

    pool = [[NSAutoreleasePool alloc] init];
    [stream writeFormat:@"220 %@\r\n", [delegate welcomeMessage]];
    [pool release];
    while(1) {
        pool = [[NSAutoreleasePool alloc] init];
        NS_DURING {
            command = [stream readLine];
        } NS_HANDLER {
            command = nil;
        } NS_ENDHANDLER;
        if (!command)
            break;
        range = [command rangeOfString:@" "];
        if (range.length) {
            arguments = [command substringFromIndex:range.location+1];
            command = [command substringToIndex:range.location];
        } else
            arguments = nil;
        NSLog(@"received command \"%@\" args \"%@\"", command, arguments);
        command = [command uppercaseString];

        if ([command isEqualToString:@"USER"]) {
            [userName release];
            userName = [arguments retain];

            if ([delegate requirePasswordForUsername:userName]) {
                [currentWorkingDirectory release];
                currentWorkingDirectory = nil;
                [stream writeFormat:@"331 Password required for %@.\r\n", userName];
            } else {
                currentWorkingDirectory = [[delegate initialWorkingDirectoryForUsername:userName] retain];
                [stream writeFormat:@"230 User %@ logged in.\r\n", userName];
            }
        } else if ([command isEqualToString:@"PASS"]) {
            [currentWorkingDirectory release];
            if ([delegate acceptPassword:arguments forUsername:userName]) {
                currentWorkingDirectory = [[delegate initialWorkingDirectoryForUsername:userName] retain];
                [stream writeFormat:@"230 User %@ logged in.\r\n", userName];
            } else {
                currentWorkingDirectory = nil;
                [stream writeString:@"530 Login incorrect.\r\n"];
            }
        } else if ([command isEqualToString:@"PASV"]) {
            unsigned long address;
            short port;

            [passiveSocket release];
            passiveSocket = [[ONTCPSocket tcpSocket] retain];
            [passiveSocket startListeningOnAnyLocalPort];
            address = [(ONInternetSocket *)[stream socket] localAddressHostNumber];
            port = [passiveSocket localAddressPort];
            [stream writeFormat:@"227 Entering Passive Mode. %d,%d,%d,%d,%d,%d\r\n", (address >> 24) & 0xff, (address >> 16) & 0xff, (address >> 8) & 0xff, address & 0xff, (port >> 8) & 0xff, port & 0xff];
        } else if ([command isEqualToString:@"PORT"]) {
            NSArray *portParts;

            portParts = [arguments componentsSeparatedByString:@","];
            if ([portParts count] != 6) {
                [stream writeString:@"501 Arguments incorrect, doofus.\r\n"];
            } else {
                long address;

                address = [[portParts objectAtIndex:0] intValue] << 24;
                address |= [[portParts objectAtIndex:1] intValue] << 16;
                address |= [[portParts objectAtIndex:2] intValue] << 8;
                address |= [[portParts objectAtIndex:3] intValue];
                dataPort = ([[portParts objectAtIndex:4] intValue] << 8) | [[portParts objectAtIndex:5] intValue];
                [dataAddress autorelease];
                dataAddress = [[ONHostAddress hostAddressWithInternetAddress:(const struct in_addr *)&address] retain];
                [stream writeString:@"200 Okay.\r\n"];
            }
        } else if ([command isEqualToString:@"LIST"]) {
            if (!currentWorkingDirectory)
                [stream writeString:@"530 Not logged in.\r\n"];
            else {
                NSEnumerator *enumerator;
                NSString *directory;
                NSString *file;
                NSArray *directories, *files;

                if (arguments) {
                    if ([arguments characterAtIndex:0] == '/')
                        directory = arguments;
                    else
                        directory = [currentWorkingDirectory stringByAppendingPathComponent:arguments];
                } else
                    directory = currentWorkingDirectory;

                if (!(directories = [delegate listDirectoriesForUsername:userName atPath:directory]))
                    [stream writeString:@"550 Can't touch that.\r\n"];
                else if (!(files = [delegate listFilesForUsername:userName atPath:directory]))
                    [stream writeString:@"550 Can't touch that.\r\n"];
                else {
                    ONTCPSocket *dataSocket;

                    if ((dataSocket = [self openDataConnection])) {
                        [stream writeString:@"150 Here it comes.\r\n"];
                        enumerator = [directories objectEnumerator];
                        while((file = [enumerator nextObject]))
                            [dataSocket writeFormat:@"drwxrwxrwx  1 ftp\tftp\t   1024 Jan  1  2000 %@\r\n", file];
                        enumerator = [files objectEnumerator];
                        while((file = [enumerator nextObject]))
                            [dataSocket writeFormat:@"-rw-rw-rw-  1 ftp\tftp\t      1 Jan  1  2000 %@\r\n", file];
                        [stream writeString:@"226 There ya go.\r\n"];
                    }
                }
            }
        } else if ([command isEqualToString:@"PWD"]) {
            if (!currentWorkingDirectory)
                [stream writeString:@"530 Not logged in.\r\n"];
            else
                [stream writeFormat:@"257 \"%@\" is your directory.\r\n", currentWorkingDirectory];
        } else if ([command isEqualToString:@"CWD"]) {
            if (!currentWorkingDirectory)
                [stream writeString:@"530 Not logged in.\r\n"];
            else {
                NSString *directory;

                if ([arguments isEqualToString:@".."])
                    directory = [currentWorkingDirectory stringByDeletingLastPathComponent];
                else if ([arguments characterAtIndex:0] == '/')
                    directory = arguments;
                else
                    directory = [currentWorkingDirectory stringByAppendingPathComponent:arguments];

                if ([delegate canChangeDirectory:directory byUsername:userName]) {
                    [currentWorkingDirectory release];
                    currentWorkingDirectory = [directory retain];
                    [stream writeFormat:@"200 directory changed to %@\r\n", currentWorkingDirectory];
                } else
                    [stream writeFormat:@"550 %@: Sorry sucker.\r\n", arguments];
            }
        } else if ([command isEqualToString:@"TYPE"]) {
            [stream writeString:@"200 Whatever buddy, I'm going to ignore it anyway.\r\n"];            
        } else if ([command isEqualToString:@"STOR"]) {
            NSString *filename;

            if (!arguments)
                [stream writeString:@"501 Arguments incorrect, doofus.\r\n"];

            if ([arguments characterAtIndex:0] == '/')
                filename = arguments;
            else
                filename = [currentWorkingDirectory stringByAppendingPathComponent:[arguments lastPathComponent]];

            if (!currentWorkingDirectory)
                [stream writeString:@"530 Not logged in.\r\n"];
            else if (![delegate allowUploadOfFilename:filename byUsername:userName]) {
                [stream writeString:@"550 Can't touch that.\r\n"];                
            } else {
                NSData *someData;
                NSMutableData *result;
                ONTCPSocket *dataSocket;

                if ((dataSocket = [self openDataConnection])) {
                    [stream writeString:@"150 I'm waiting.\r\n"];
                    result = [NSMutableData data];
                    while((someData = [dataSocket readData]))
                        [result appendData:someData];
                    [stream writeString:@"226 Gotcha.\r\n"];
                    [delegate user:userName uploadedFilename:filename withData:result];
                }
            }
        } else if ([command isEqualToString:@"QUIT"]) {
            [stream writeString:@"221 See ya.\r\n"];
            break;
        } else {
            [stream writeString:@"502 Unimplemented, too bad.\r\n"];
        }
        [pool release];
    }
    [stream release];
    stream = nil;
    [pool release];
}

@end
