// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFTPServer/OFTPDelegate.h,v 1.4 2000/11/02 18:45:21 toon Exp $

#import <Foundation/Foundation.h>

@protocol OFTPDelegate 

- (NSString *)welcomeMessage;
- (BOOL)requirePasswordForUsername:(NSString *)aUser;
- (BOOL)acceptPassword:(NSString *)aPassword forUsername:(NSString *)aUser;
- (NSString *)initialWorkingDirectoryForUsername:(NSString *)aUser;

- (NSArray *)listDirectoriesForUsername:(NSString *)aUser atPath:(NSString *)directory;
- (BOOL)canChangeDirectory:(NSString *)aDirectory byUsername:(NSString *)aUser;
- (NSArray *)listFilesForUsername:(NSString *)aUser atPath:(NSString *)directory;
- (BOOL)allowUploadOfFilename:(NSString *)aFile byUsername:(NSString *)aUser;
- (void)user:(NSString *)aUser uploadedFilename:(NSString *)aFile withData:(NSData *)data;

@end
