// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//

#import "OFTPServer.h"
#import <OmniNetworking/OmniNetworking.h>
#import "OFTPConnection.h"

@implementation OFTPServer

- initWithLocalPort:(unsigned short int)port andDelegate:(id <OFTPDelegate, NSObject>)aDelegate;
{
    [super init];
    delegate = [aDelegate retain];
    mainSocket = [[ONTCPSocket tcpSocket] retain];
    [mainSocket startListeningOnLocalPort:port];
    return self;
}

- (void)processConnections;
{
    while(1) {
        NSAutoreleasePool *pool;
        ONTCPSocket *newSocket;
        OFTPConnection *connection;

        pool = [[NSAutoreleasePool alloc] init];
        newSocket = [mainSocket acceptConnectionOnNewSocket];
        connection = [[OFTPConnection alloc] initWithSocket:newSocket andDelegate:delegate];
        [NSThread detachNewThreadSelector:@selector(processConnection) toTarget:connection withObject:nil];
        [pool release];
    }
}

@end
