// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//

#import "OFTPTestDelegate.h"

@implementation OFTPTestDelegate

- (NSString *)welcomeMessage;
{
    return @"OFTP Test";
}

- (BOOL)requirePasswordForUsername:(NSString *)aUser;
{
    NSLog(@"- requirePasswordForUsername:\"%@\"", aUser);
    return YES;
}

- (BOOL)acceptPassword:(NSString *)aPassword forUsername:(NSString *)aUser;
{
    NSLog(@"- acceptPassword:\"%@\" forUsername:\"%@\"", aPassword, aUser);
    return YES;
}

- (NSString *)initialWorkingDirectoryForUsername:(NSString *)aUser;
{
    NSLog(@"- initialWorkingDirectoryForUsername:\"%@\"", aUser);
    return @"/";
}

- (NSArray *)listDirectoriesForUsername:(NSString *)aUser atPath:(NSString *)directory;
{
    NSLog(@"- listDirectoriesForUsername:\"%@\" atPath:\"%@\"", aUser, directory);
    if ([directory isEqualToString:@"/"])
        return [NSArray arrayWithObjects:@"colors", @"flavors", nil];
    else
        return [NSArray array];
}

- (BOOL)canChangeDirectory:(NSString *)aDirectory byUsername:(NSString *)aUser;
{
    if ([aDirectory isEqualToString:@"/"])
        return YES;
    if ([aDirectory isEqualToString:@"/colors"])
        return YES;
    if ([aDirectory isEqualToString:@"/flavors"])
        return YES;
    return NO;
}

- (NSArray *)listFilesForUsername:(NSString *)aUser atPath:(NSString *)directory;
{
    NSLog(@"- listFilesForUsername:\"%@\" atPath:\"%@\"", aUser, directory);
    if ([directory isEqualToString:@"/colors"])
        return [NSArray arrayWithObjects:@"red", @"blue", @"green", nil];
    else if ([directory isEqualToString:@"/flavors"])
        return [NSArray arrayWithObjects:@"chocolate", @"vanilla", @"strawberry", nil];
    else
        return [NSArray array];
}

- (BOOL)allowUploadOfFilename:(NSString *)aFile byUsername:(NSString *)aUser;
{
    NSLog(@"- allowUploadOfFilename:\"%@\" byUsername:\"%@\"", aFile, aUser);
    return YES;
}

- (void)user:(NSString *)aUser uploadedFilename:(NSString *)aFile withData:(NSData *)data;
{
    NSLog(@"-user:\"%@\" uploadedFilename:\"%@\" withData:(length=%d)", aUser, aFile, [data length]);
}

@end
