// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniFoundation/OFObject-Queue.h>

#import <Foundation/Foundation.h>
#import <objc/objc-class.h>
#import <OmniBase/OmniBase.h>

#import <OmniFoundation/NSThread-OFExtensions.h>
#import <OmniFoundation/OFMessageQueue.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Scheduling.subproj/OFObject-Queue.m,v 1.7 2000/01/19 23:35:33 kc Exp $")


@implementation NSObject (Queue)

+ (void)queueSelectorOnce:(SEL)aSelector;
{
    [[OFMessageQueue mainQueue] queueSelectorOnce:aSelector forObject:self];
}

- (void)queueSelector:(SEL)aSelector;
{
    [[OFMessageQueue mainQueue] queueSelector:aSelector forObject:self];
}

- (void)queueSelectorOnce:(SEL)aSelector;
{
    [[OFMessageQueue mainQueue] queueSelectorOnce:aSelector forObject:self];
}

- (void)queueSelector:(SEL)aSelector withObject:(id)anObject;
{
    [[OFMessageQueue mainQueue] queueSelector:aSelector forObject:self withObject:anObject];
}

- (void)queueSelectorOnce:(SEL)aSelector withObject:(id)anObject;
{
    [[OFMessageQueue mainQueue] queueSelectorOnce:aSelector forObject:self withObject:anObject];
}

- (void)queueSelector:(SEL)aSelector withObject:(id)anObject withObject:(id)anotherObject;
{
    [[OFMessageQueue mainQueue] queueSelector:aSelector forObject:self withObject:anObject withObject:anotherObject];
}

- (void)queueSelector:(SEL)aSelector withBool:(BOOL)aBool;
{
    [[OFMessageQueue mainQueue] queueSelector:aSelector forObject:self withBool:aBool];
}

- (void)queueSelector:(SEL)aSelector withInt:(int)anInt;
{
    [[OFMessageQueue mainQueue] queueSelector:aSelector forObject:self withInt:anInt];
}

- (void)queueSelector:(SEL)aSelector withInt:(int)anInt withInt:(int)anotherInt;
{
    [[OFMessageQueue mainQueue] queueSelector:aSelector forObject:self withInt:anInt withInt:anotherInt];
}

//

+ (void)mainThreadPerformSelectorOnce:(SEL)aSelector;
{
    if ([NSThread inMainThread])
	[self performSelector:aSelector];
    else
	[self queueSelectorOnce:aSelector];
}

- (void)mainThreadPerformSelector:(SEL)aSelector;
{
    if ([NSThread inMainThread])
	[self performSelector:aSelector];
    else
	[self queueSelector:aSelector];
}

- (void)mainThreadPerformSelectorOnce:(SEL)aSelector;
{
    if ([NSThread inMainThread])
	[self performSelector:aSelector];
    else
	[self queueSelectorOnce:aSelector];
}

- (void)mainThreadPerformSelector:(SEL)aSelector withObject:(id)anObject;
{
    if ([NSThread inMainThread])
	[self performSelector:aSelector withObject:anObject];
    else
	[self queueSelector:aSelector withObject:anObject];
}

- (void)mainThreadPerformSelector:(SEL)aSelector withObject:(id)anObject withObject:(id)anotherObject;
{
    if ([NSThread inMainThread])
	[self performSelector:aSelector withObject:anObject withObject:anotherObject];
    else
	[self queueSelector:aSelector withObject:anObject withObject:anotherObject];
}

- (void)mainThreadPerformSelectorOnce:(SEL)aSelector withObject:(id)anObject;
{
    if ([NSThread inMainThread])
	[self performSelector:aSelector withObject:anObject];
    else
	[self queueSelectorOnce:aSelector withObject:anObject];
}

- (void)mainThreadPerformSelector:(SEL)aSelector withBool:(BOOL)aBool;
{
    if ([NSThread inMainThread]) {
	Method method;

	method = class_getInstanceMethod(isa, aSelector);
        if (!method)
            [NSException raise:NSInvalidArgumentException format:@"%@ does not respond to the selector %@", self, NSStringFromSelector(aSelector)];
	method->method_imp(self, aSelector, aBool);
    } else
	[self queueSelector:aSelector withBool:aBool];
}

- (void)mainThreadPerformSelector:(SEL)aSelector withInt:(int)anInt;
{
    if ([NSThread inMainThread]) {
	Method method;

	method = class_getInstanceMethod(isa, aSelector);
        if (!method)
            [NSException raise:NSInvalidArgumentException format:@"%@ does not respond to the selector %@", self, NSStringFromSelector(aSelector)];
	method->method_imp(self, aSelector, anInt);
    } else
	[self queueSelector:aSelector withInt:anInt];
}

- (void)mainThreadPerformSelector:(SEL)aSelector withInt:(int)anInt withInt:(int)anInt2;
{
    if ([NSThread inMainThread]) {
	Method method;

	method = class_getInstanceMethod(isa, aSelector);
        if (!method)
            [NSException raise:NSInvalidArgumentException format:@"%@ does not respond to the selector %@", self, NSStringFromSelector(aSelector)];
	method->method_imp(self, aSelector, anInt, anInt2);
    } else
	[self queueSelector:aSelector withInt:anInt withInt:anInt2];
}

@end
