// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/DataStructures.subproj/OFRandom.h,v 1.8 2000/06/09 06:39:07 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <OmniFoundation/FrameworkDefines.h>
#import <OmniBase/system.h>

#define OF_RANDOM_MAX (INT_MAX)

// Some platforms don't provide random number generation and of those that do, there are many different variants.  We provide a common random number generator rather than have to deal with each platform independently.  Additionally, we allow the user to maintain several random number generators.

typedef struct {
    unsigned long y; // current value any number between zero and M-1
} OFRandomState;

OmniFoundation_EXTERN OFRandomState OFDefaultRandomState;
// This random state will automatically be seeded at startup.  This initialization will occur during +[OBPostLoader processClasses].  The default random state should not be used before this method has completed.

OmniFoundation_EXTERN void OFRandomSeed(OFRandomState *state, unsigned long y);
OmniFoundation_EXTERN unsigned long OFRandomNextState(OFRandomState *state);

#define OFRandomNext() OFRandomNextState(&OFDefaultRandomState)


static inline float OFRandomFloat(OFRandomState *state)
/*.doc.
Returns a number in the range [0..1]
*/
{
    return (float)OFRandomNextState(state)/(float)OF_RANDOM_MAX;
}
