// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFTimeSpanFormatter.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Formatters.subproj/OFTimeSpanFormatter.m,v 1.2 2000/06/09 09:35:39 nygard Exp $")

@implementation OFTimeSpanFormatter

- (NSString *)stringForObjectValue:(id)object;
{
    if ([object isKindOfClass:[NSDecimalNumber class]]) {
        NSMutableString *string;
        int intValue;
        float floatValue;
        unsigned int part;

        string = [NSMutableString string];
        intValue = [(NSDecimalNumber *)object intValue];
        floatValue = [(NSDecimalNumber *)object floatValue];
        floatValue -= (float)intValue;

        if ((part = intValue / 40)) {
            [string appendFormat:@"%dw", part];
            intValue -= part*40;
        }
        if ((part = intValue / 8)) {
            [string appendFormat:@"%dd", part];
            intValue -= part*8;
        }
        if (floatValue) {
            floatValue += (float)intValue;
            [string appendFormat:@"%1.1fh", floatValue];
        } else if (intValue || ![string length]) {
            [string appendFormat:@"%dh", intValue];
        }
        return string;
    } else
        return nil;
}

- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error;
{
    BOOL gotAnythingValid = NO;
    float number, hours = 0.0;
    NSScanner *scanner;
    
    if (![string length]) {
        *obj = nil;
        return YES;
    }

    scanner = [NSScanner scannerWithString:string];
    while(1) {
        if (![scanner scanFloat:&number]) {
            if (gotAnythingValid)
                break;
            if (error)
                *error = @"Invalid time span format";
            return NO;
        }
        if ([scanner scanString:@"m" intoString:NULL] || [scanner scanString:@"M" intoString:NULL]) {
            number *= 160.0;
        } else if ([scanner scanString:@"w" intoString:NULL] || [scanner scanString:@"W" intoString:NULL]) {
            number *= 40.0;
        } else if ([scanner scanString:@"d" intoString:NULL] || [scanner scanString:@"D" intoString:NULL]) {
            number *= 8.0;
        } else if ([scanner scanString:@"h" intoString:NULL] || [scanner scanString:@"H" intoString:NULL]) {
        }
        hours += number;
        gotAnythingValid = YES;
    }

    *obj = [NSDecimalNumber numberWithFloat:hours];
    return YES;
}

@end
