// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniFoundation/CFString-OFExtensions.h>

#import <OmniBase/rcsid.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/CoreFoundationExtensions/CFString-OFExtensions.m,v 1.2 2000/08/31 07:40:50 bungi Exp $")

void OFLowercaseCharacters(UniChar *characters, CFIndex count)
{
    while (count--) {
        UniChar c, lower;
        
        c = *characters;
        if (c >= 'A' && c <= 'Z') {
            lower = 'a' + (c - 'A');
            *characters = lower;
        } else if (c > 0x7f) {
            lower = toulower(c);
            if (lower != c)
                // Don't do the write unless needed
                *characters = lower;
        } else {
            // leave the character alone
        }
        
        characters++;
    }
}

void OFLowercaseCharactersInto(const UniChar *source, UniChar *dest, CFIndex count)
{
    while (count--) {
        UniChar c;
        
        c = *source;
        if (c >= 'A' && c <= 'Z') {
            *dest = 'a' + (c - 'A');
        } else if (c > 0x7f) {
            *dest = toulower(c);
        } else {
            *dest = c;
        }
        
        source++;
        dest++;
    }
}


void OFUppercaseCharacters(UniChar *characters, CFIndex count)
{
    while (count--) {
        UniChar c, upper;
        
        c = *characters;
        if (c >= 'A' && c <= 'Z') {
            upper = 'a' + (c - 'A');
            *characters = upper;
        } else if (c > 0x7f) {
            upper = touupper(c);
            if (upper != c)
                // Don't do the write unless needed
                *characters = upper;
        }
        
        characters++;
    }
}

void OFUppercaseCharactersInto(const UniChar *source, UniChar *dest, CFIndex count)
{
    while (count--) {
        UniChar c;
        
        c = *source;
        if (c >= 'A' && c <= 'Z') {
            *dest = 'a' + (c - 'A');
        } else if (c > 0x7f) {
            *dest = touupper(c);
        } else {
            *dest = c;
        }
        
        source++;
        dest++;
    }
}


#if 0

#import <stdio.h>
#import <stdlib.h>

#import <Foundation/NSObject.h>

@interface __CFString_OFExtensions : NSObject
@end

@implementation __CFString_OFExtensions : NSObject

+ (void) didLoad;
{
    CFStringRef allCharsString;
    CFMutableStringRef allLowerCharsString, allUpperCharsString;
    UniChar *allChars, lower;
    unsigned int c, length;
    
    allChars = malloc(sizeof(UniChar) * 0x10000);
    for (c = 0; c < 0x10000; c++) {
        allChars[c] = (UniChar)c;
    }
    
    allCharsString = CFStringCreateWithCharacters(kCFAllocatorDefault, allChars, 0x10000);
    allLowerCharsString = CFStringCreateMutableCopy(kCFAllocatorDefault, 0x10000, allCharsString);
    allUpperCharsString = CFStringCreateMutableCopy(kCFAllocatorDefault, 0x10000, allCharsString);
    
    CFStringLowercase(allLowerCharsString, NULL);
    CFStringUppercase(allUpperCharsString, NULL);

    length = CFStringGetLength(allLowerCharsString);
    printf("lower length = 0x%x\n", length);
    for (c = 0; c < length; c++) {
        lower = CFStringGetCharacterAtIndex(allLowerCharsString, c);
        if (lower != c) {
            fprintf(stderr, "c: %d  lower: %d  diff: %d\n", (unsigned int)c, (unsigned int)lower, (int)c - (int)lower);
        }
    }
    
    length = CFStringGetLength(allUpperCharsString);
    printf("lower length = 0x%x\n", length);
    for (c = 0; c < length; c++) {
        lower = CFStringGetCharacterAtIndex(allUpperCharsString, c);
        if (lower != c) {
            fprintf(stderr, "c: %d  upper: %d  diff: %d\n", (unsigned int)c, (unsigned int)lower, (int)c - (int)lower);
        }
    }
    
    CFRelease(allCharsString);
    CFRelease(allLowerCharsString);
    CFRelease(allUpperCharsString);
}

@end

#endif
