// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniFoundation/OFMultiValueDictionary.h>

#import <OmniFoundation/CFDictionary-OFExtensions.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/DataStructures.subproj/OFMultiValueDictionary.m,v 1.12 2000/08/31 08:13:59 bungi Exp $")

@implementation OFMultiValueDictionary

- init;
{
    return [self initWithCaseInsensitiveKeys: NO];
}

- initWithCaseInsensitiveKeys: (BOOL) caseInsensitivity;
{
    if (caseInsensitivity)
        dictionary = OFCreateCaseInsensitiveKeyMutableDictionary();
    else
        dictionary = [[NSMutableDictionary alloc] init];

    return self;
}

- (void)dealloc;
{
    [dictionary release];
    [super dealloc];
}

- (NSArray *)arrayForKey:(NSString *)aKey;
{
    return [dictionary objectForKey:aKey];
}

- (id)firstObjectForKey:(NSString *)aKey;
{
    return [[dictionary objectForKey:aKey] objectAtIndex:0];
}

- (id)lastObjectForKey:(NSString *)aKey;
{
    return [[dictionary objectForKey:aKey] lastObject];
}

- (void)addObject:(id)anObject forKey:(NSString *)aKey;
{
    NSMutableArray *valueArray;

    valueArray = [dictionary objectForKey:aKey];
    if (!valueArray) {
	valueArray = [NSMutableArray arrayWithObject:anObject];
	[dictionary setObject:valueArray forKey:aKey];
    } else
	[valueArray addObject:anObject];
}

- (NSEnumerator *)keyEnumerator;
{
    return [dictionary keyEnumerator];
}

- (NSArray *)allKeys;
{
    return [dictionary allKeys];
}

- (NSMutableDictionary *)dictionary;
{
    return dictionary;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (dictionary)
	[debugDictionary setObject:dictionary forKey:@"dictionary"];
    return debugDictionary;
}

@end
