// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFTimeSpanFormatter.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Formatters.subproj/OFTimeSpanFormatter.m,v 1.3 2000/08/17 04:15:11 luke Exp $")

@implementation OFTimeSpanFormatter

- (void)setUseVerboseFormat:(BOOL)shouldUseVerbose;
{
    shouldUseVerboseFormat = shouldUseVerbose;
}

- (BOOL)shouldUseVerboseFormat;
{
    return shouldUseVerboseFormat;
}

- (NSString *)stringForObjectValue:(id)object;
{
    if ([object isKindOfClass:[NSDecimalNumber class]]) {
        NSMutableArray *components;
        int intValue;
        float floatValue;
        unsigned int part;

        components = [NSMutableArray array];
        intValue = [(NSDecimalNumber *)object intValue];
        floatValue = [(NSDecimalNumber *)object floatValue];
        floatValue -= (float)intValue;

        if ((part = intValue / 40)) {
            if (shouldUseVerboseFormat) {
                if (part > 1.0)
                    [components addObject:[NSString stringWithFormat:@"%d weeks", part]];
                else
                    [components addObject:[NSString stringWithFormat:@"%d week", part]];
            } else
                [components addObject:[NSString stringWithFormat:@"%dw", part]];

            intValue -= part*40;
        }
        if ((part = intValue / 8)) {
            if (shouldUseVerboseFormat) {
                if (part > 1.0)
                    [components addObject:[NSString stringWithFormat:@"%d days", part]];
                else
                    [components addObject:[NSString stringWithFormat:@"%d day", part]];
            } else
                [components addObject:[NSString stringWithFormat:@"%dd", part]];

            intValue -= part*8;
        }
        if (floatValue) {
            floatValue += (float)intValue;
            if (shouldUseVerboseFormat) {
                if (floatValue > 1.0)
                    [components addObject:[NSString stringWithFormat:@"%1.1f hours", floatValue]];
                else
                    [components addObject:[NSString stringWithFormat:@"%1.1f hour", floatValue]];
            } else
                [components addObject:[NSString stringWithFormat:@"%1.1fh", floatValue]];
        } else if (intValue || ![components count]) {
            if (shouldUseVerboseFormat) {
                if (intValue > 1)
                    [components addObject:[NSString stringWithFormat:@"%d hours", intValue]];
                else
                    [components addObject:[NSString stringWithFormat:@"%d hour", intValue]];
            } else
                [components addObject:[NSString stringWithFormat:@"%dh", intValue]];
        }
        return [components componentsJoinedByString:@" "];
    } else
        return nil;
}

- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error;
{
    BOOL gotAnythingValid = NO;
    float number, hours = 0.0;
    NSScanner *scanner;
    NSCharacterSet *whitespaceCharacterSet;
    
    if (![string length]) {
        *obj = nil;
        return YES;
    }

    whitespaceCharacterSet = [NSCharacterSet whitespaceCharacterSet];
    scanner = [NSScanner scannerWithString:string];
    while(1) {
        // Eat whitespace
        [scanner scanCharactersFromSet:whitespaceCharacterSet intoString:(NSString **)0];
        
        if (![scanner scanFloat:&number]) {
            if (gotAnythingValid)
                break;
            if (error)
                *error = @"Invalid time span format";
            return NO;
        }
        if ([scanner scanString:@"m" intoString:NULL] || [scanner scanString:@"M" intoString:NULL]) {
            number *= 160.0;
        } else if ([scanner scanString:@"w" intoString:NULL] || [scanner scanString:@"W" intoString:NULL]) {
            number *= 40.0;
        } else if ([scanner scanString:@"d" intoString:NULL] || [scanner scanString:@"D" intoString:NULL]) {
            number *= 8.0;
        } else if ([scanner scanString:@"h" intoString:NULL] || [scanner scanString:@"H" intoString:NULL]) {
        }
        hours += number;
        gotAnythingValid = YES;
    }

    *obj = [NSDecimalNumber numberWithFloat:hours];
    return YES;
}

@end
