// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/OFStringDecoder.h,v 1.3 2000/10/23 20:45:17 kc Exp $

#import <Foundation/NSString.h>
#import <CoreFoundation/CFString.h>
#import <OmniFoundation/FrameworkDefines.h>

struct OFStringDecoderState {
    CFStringEncoding encoding;
    
    union {
       struct {
          unichar partialCharacter;
          unsigned short utf8octetsremaining;
       } utf8;
       /* TODO: more state vars for other encodings */
    } vars;
};

struct OFCharacterScanResult {
    struct OFStringDecoderState state;
        
    unsigned int bytesConsumed;
    unsigned int charactersProduced;
};

/* Information about encodings */
OmniFoundation_EXTERN BOOL OFCanScanEncoding(CFStringEncoding anEncoding);
OmniFoundation_EXTERN BOOL OFEncodingIsSimple(CFStringEncoding anEncoding);

/* Functions for decoding a string */
OmniFoundation_EXTERN struct OFStringDecoderState OFInitialStateForEncoding(CFStringEncoding anEncoding);
OmniFoundation_EXTERN struct OFCharacterScanResult OFScanCharactersIntoBuffer(struct OFStringDecoderState state,  unsigned char *in_bytes, unsigned int in_bytes_count, unichar *out_characters, unsigned int out_characters_max);
OmniFoundation_EXTERN BOOL OFDecoderContainsPartialCharacters(struct OFStringDecoderState state);

/* An exception which can be raised by the above functions */
OmniFoundation_EXTERN NSString *OFCharacterConversionExceptionName;

