// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFTimeSpanFormatter.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "NSObject-OFExtensions.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Formatters.subproj/OFTimeSpanFormatter.m,v 1.4 2000/11/16 12:30:18 wjs Exp $")

@implementation OFTimeSpanFormatter

- (void)setUseVerboseFormat:(BOOL)shouldUseVerbose;
{
    shouldUseVerboseFormat = shouldUseVerbose;
}

- (BOOL)shouldUseVerboseFormat;
{
    return shouldUseVerboseFormat;
}

- (NSString *)stringForObjectValue:(id)object;
{
    if ([object isKindOfClass:[NSDecimalNumber class]]) {
        NSMutableArray *components;
        int intValue;
        float floatValue;
        unsigned int part;

        components = [NSMutableArray array];
        intValue = [(NSDecimalNumber *)object intValue];
        floatValue = [(NSDecimalNumber *)object floatValue];
        floatValue -= (float)intValue;

        if ((part = intValue / 40)) {
            if (shouldUseVerboseFormat) {
                if (part > 1.0)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d weeks", @"OmniFoundation", [self bundle], time span formatter span), part]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d week", @"OmniFoundation", [self bundle], time span formatter span singular), part]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%dw", @"OmniFoundation", [self bundle], time span formatter span abbreviated), part]];

            intValue -= part*40;
        }
        if ((part = intValue / 8)) {
            if (shouldUseVerboseFormat) {
                if (part > 1.0)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d days", @"OmniFoundation", [self bundle], time span formatter span), part]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d day", @"OmniFoundation", [self bundle], time span formatter span singular), part]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%dd", @"OmniFoundation", [self bundle], time span formatter span abbreviated), part]];

            intValue -= part*8;
        }
        if (floatValue) {
            floatValue += (float)intValue;
            if (shouldUseVerboseFormat) {
                if (floatValue > 1.0)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%1.1f hours", @"OmniFoundation", [self bundle], time span formatter span), floatValue]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%1.1f hour", @"OmniFoundation", [self bundle], time span formatter span singular), floatValue]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%1.1fh", @"OmniFoundation", [self bundle], time span formatter span abbreviated), floatValue]];
        } else if (intValue || ![components count]) {
            if (shouldUseVerboseFormat) {
                if (intValue > 1)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d hours", @"OmniFoundation", [self bundle], time span formatter span), intValue]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d hour", @"OmniFoundation", [self bundle], time span formatter span singular), intValue]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%dh", @"OmniFoundation", [self bundle], time span formatter span abbreviated), intValue]];
        }
        return [components componentsJoinedByString:@" "];
    } else
        return nil;
}

- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error;
{
    BOOL gotAnythingValid = NO;
    float number, hours = 0.0;
    NSScanner *scanner;
    NSCharacterSet *whitespaceCharacterSet;
    
    if (![string length]) {
        *obj = nil;
        return YES;
    }

    whitespaceCharacterSet = [NSCharacterSet whitespaceCharacterSet];
    scanner = [NSScanner scannerWithString:string];
    while(1) {
        // Eat whitespace
        [scanner scanCharactersFromSet:whitespaceCharacterSet intoString:(NSString **)0];
        
        if (![scanner scanFloat:&number]) {
            if (gotAnythingValid)
                break;
            if (error)
                *error = NSLocalizedStringFromTableInBundle(@"Invalid time span format", @"OmniFoundation", [self bundle], formatter input error);
            return NO;
        }
        if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"m", @"OmniFoundation", [self bundle], timespan formatter lowercase first character in months) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"M", @"OmniFoundation", [self bundle], timespan formatter uppercase first character in months) intoString:NULL]) {
            number *= 160.0;
        } else if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"w", @"OmniFoundation", [self bundle], timespan formatter lowercase first character in weeks) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"W", @"OmniFoundation", [self bundle], timespan formatter uppercase first character in weeks) intoString:NULL]) {
            number *= 40.0;
        } else if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"d", @"OmniFoundation", [self bundle], timespan formatter lowercase first character in days) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"D", @"OmniFoundation", [self bundle], timespan formatter uppercase first character in days) intoString:NULL]) {
            number *= 8.0;
        } else if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"h", @"OmniFoundation", [self bundle], timespan formatter lowercase first character in hours) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"H", @"OmniFoundation", [self bundle], timespan formatter uppercase first character in hours) intoString:NULL]) {
        }
        hours += number;
        gotAnythingValid = YES;
    }

    *obj = [NSDecimalNumber numberWithFloat:hours];
    return YES;
}

@end
