// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Carbon/OFResourceFork.h,v 1.4 2001/02/16 02:14:02 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <CoreServices/CoreServices.h>

@class NSArray, NSData, NSString;

extern NSString *OFDataForkName;
extern NSString *OFResourceForkName;

typedef enum _OFForkType {
    OFDataForkType,
    OFResourceForkType
} OFForkType;

@interface OFResourceFork : OFObject
{
    NSString   *path;
    SInt16      refNum;
}

- initWithContentsOfFile: (NSString *) aPath forkType: (OFForkType) aForkType;
- initWithContentsOfFile: (NSString *) aPath;

- (NSString *) path;

- (NSArray *) stringsForResourceWithIdentifier: (ResID) resourceIdentifier;

- (short) countForResourceType: (ResType) resourceType;
- (NSData *) dataForResourceType: (ResType) resourceType atIndex: (short) index;

@end
