// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniFoundation/OmniFoundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Tests/OFDedicatedThreadSchedulerTest.m,v 1.3 2001/02/15 15:14:05 kc Exp $")

@interface TestObject : NSObject
{
}

- (void) scheduleFireMessages;
- (void) fire;

@end


// Put this into a float so it is in four bytes and can be atomically written
static float lastFireDate;

@implementation TestObject

- (void) scheduleFireMessages;
{
    OFScheduler *scheduler;
    int i;
    
    scheduler = [OFScheduler dedicatedThreadScheduler];
    while (YES) {
        for (i = 0; i < 1000; i++) {
            NSAutoreleasePool *pool;
            
            pool = [[NSAutoreleasePool alloc] init];
            [scheduler scheduleSelector:@selector(fire) onObject:self withObject:nil afterTime: 0.1];
            [pool release];
        }
        
        NSLog(@"Last fired %f seconds ago", [NSDate timeIntervalSinceReferenceDate] - lastFireDate);
    }
}

- (void) fire;
{
    lastFireDate = [NSDate timeIntervalSinceReferenceDate];
}

@end


int main(int argc, char *argv[])
{
    NSAutoreleasePool *pool;
    TestObject *target;
    
    pool = [[NSAutoreleasePool alloc] init];
    [OBPostLoader processClasses];
    target = [[TestObject alloc] init];
    lastFireDate = [NSDate timeIntervalSinceReferenceDate];
    [NSThread detachNewThreadSelector:@selector(scheduleFireMessages) toTarget:target withObject: nil];
    [pool release];

    [[NSRunLoop currentRunLoop] runUntilDate: [NSDate distantFuture]];
    return 0;
}
