// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFWeakRetainConcreteImplementation.h"

#import <Foundation/Foundation.h>
#import <objc/objc-class.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/OFWeakRetainConcreteImplementation.m,v 1.7 2001/03/23 15:15:04 kc Exp $")


@implementation NSObject (OFWeakRetain)

- (id)weakRetain;
{
    [self retain];
    [(id <OFWeakRetain>)self incrementWeakRetainCount];
    return self;
}

- (void)weakRelease;
{
    [(id <OFWeakRetain>)self decrementWeakRetainCount];
    [self release];
}

- (id)weakAutorelease;
{
    [(id <OFWeakRetain>)self decrementWeakRetainCount];
    return [self autorelease];
}

static NSMutableSet *warnedClasses = nil;

- (void)incrementWeakRetainCount;
    // Not thread-safe, but this is debugging code
{
    if (warnedClasses == nil)
        warnedClasses = [[NSMutableSet alloc] init];

    if (![warnedClasses containsObject:isa]) {
        [warnedClasses addObject:isa];
        NSLog(@"%@ does not implement the OFWeakRetain protocol", NSStringFromClass(isa));
    }
}

- (void)decrementWeakRetainCount;
{
}

@end
