// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniFoundation/OFResultHolder.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Scheduling.subproj/OFResultHolder.m,v 1.6 2001/02/15 15:14:03 kc Exp $")

@implementation OFResultHolder

- init
{
    self = [super init];
    theResult = nil;
    lock = [[NSConditionLock alloc] initWithCondition:NO];
    return self;
}

- (void)dealloc
{
    [theResult release];
    theResult = nil;
    [lock release];
    lock = nil;
    [super dealloc];
}

- (void)setResult:anObject
{
    [lock lock];
    [anObject retain];
    [theResult release];
    theResult = anObject;
    [lock unlockWithCondition:YES];
}

- (id)getResult
{
    id result;
    [lock lockWhenCondition:YES];
    result = [theResult retain];
    [lock unlock];
    return [result autorelease];
}

@end
