// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniFoundation/DataStructures.subproj/OFCharacterSet.h,v 1.3 2001/06/01 00:59:38 krevis Exp $

#import <OmniFoundation/OFObject.h>

@class NSCharacterSet;

#import <Foundation/NSString.h> // For unichar

#import <OmniFoundation/OFByte.h>

#define OFCharacterSetBitmapRepLength ((1 << 16) >> 3)

@interface OFCharacterSet : OFObject
{
@public
    OFByte bitmapRep[OFCharacterSetBitmapRepLength];
}

//
- initWithCharacterSet:(NSCharacterSet *)characterSet;
- initWithOFCharacterSet:(OFCharacterSet *)ofCharacterSet;
- initWithString:(NSString *)string;

// API
- (BOOL)characterIsMember:(unichar)character;
- (void)addCharacter:(unichar)character;
- (void)removeCharacter:(unichar)character;

- (void)addCharactersFromOFCharacterSet:(OFCharacterSet *)ofCharacterSet;
- (void)removeCharactersFromOFCharacterSet:(OFCharacterSet *)ofCharacterSet;

- (void)addCharactersFromCharacterSet:(NSCharacterSet *)characterSet;
- (void)removeCharactersFromCharacterSet:(NSCharacterSet *)characterSet;

- (void)addCharactersInString:(NSString *)string;
- (void)removeCharactersInString:(NSString *)string;

- (void)addAllCharacters;
- (void)removeAllCharacters;

- (void)invert;

@end

static inline BOOL OFCharacterSetHasMember(OFCharacterSet *unicharSet, unichar character)
{
    return unicharSet->bitmapRep[character >> 3] & (((unsigned)1) << (character & 7));
}

static inline void OFCharacterSetAddCharacter(OFCharacterSet *unicharSet, unichar character)
{
    unicharSet->bitmapRep[character >> 3] |= (((unsigned)1) << (character & 7));
}

static inline void OFCharacterSetRemoveCharacter(OFCharacterSet *unicharSet, unichar character)
{
    unicharSet->bitmapRep[character >> 3] &= ~(((unsigned)1) << (character & 7));
}

