// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFCharacterSet.h"

#import <Foundation/Foundation.h>
#import <OmniBase/rcsid.h>


RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniFoundation/DataStructures.subproj/OFCharacterSet.m,v 1.2 2001/06/01 00:59:38 krevis Exp $");

@interface OFCharacterSet (Private)
@end

@implementation OFCharacterSet

// Init and dealloc

- init;
{
    if (![super init])
        return nil;

    [self removeAllCharacters];
    return self;
}

- initWithCharacterSet:(NSCharacterSet *)characterSet;
{
    if (![self init])
        return nil;
        
    [self addCharactersFromCharacterSet:characterSet];
    
    return self;
}

- initWithOFCharacterSet:(OFCharacterSet *)ofCharacterSet;
{
    if (![self init])
        return nil;
        
    [self addCharactersFromOFCharacterSet:ofCharacterSet];
    return self;
}

- initWithString:(NSString *)string;
{
    if (![self init])
        return nil;
        
    [self addCharactersInString:string];
    return self;
}

- (void)dealloc;
{
    [super dealloc];
}


// API

- (BOOL)characterIsMember:(unichar)character;
{
    return OFCharacterSetHasMember(self, character);
}
- (void)addCharacter:(unichar)character;
{
    OFCharacterSetAddCharacter(self, character);
}
- (void)removeCharacter:(unichar)character;
{
    OFCharacterSetRemoveCharacter(self, character);
}

//

- (void)addCharactersFromOFCharacterSet:(OFCharacterSet *)ofCharacterSet;
{
    unsigned int maskIndex;

    maskIndex = OFCharacterSetBitmapRepLength;
    while (maskIndex--) {
        bitmapRep[maskIndex] |= ofCharacterSet->bitmapRep[maskIndex];
    }
}

- (void)removeCharactersFromOFCharacterSet:(OFCharacterSet *)ofCharacterSet;
{
    unsigned int maskIndex;

    maskIndex = OFCharacterSetBitmapRepLength;
    while (maskIndex--) {
        bitmapRep[maskIndex] &= (~ofCharacterSet->bitmapRep[maskIndex]);
    }
}

- (void)addCharactersFromCharacterSet:(NSCharacterSet *)characterSet;
{
    unsigned int maskIndex;
    const OFByte *otherBitmap;
    
    otherBitmap = [[characterSet bitmapRepresentation] bytes];
    maskIndex = OFCharacterSetBitmapRepLength;
    while (maskIndex--) {
        bitmapRep[maskIndex] |= otherBitmap[maskIndex];
    }
}

- (void)removeCharactersFromCharacterSet:(NSCharacterSet *)characterSet;
{
    unsigned int maskIndex;
    const OFByte *otherBitmap;
    
    otherBitmap = [[characterSet bitmapRepresentation] bytes];
    maskIndex = OFCharacterSetBitmapRepLength;
    while (maskIndex--) {
        bitmapRep[maskIndex] &= (~otherBitmap[maskIndex]);
    }
}

- (void)addCharactersInString:(NSString *)string;
{
    CFStringInlineBuffer inlineBuffer;
    unsigned int characterIndex, length;
    
    length = CFStringGetLength((CFStringRef)string);
    CFStringInitInlineBuffer((CFStringRef)string, &inlineBuffer, CFRangeMake(0, length));
    for (characterIndex = 0; characterIndex < length; characterIndex++)
        OFCharacterSetAddCharacter(self, CFStringGetCharacterFromInlineBuffer(&inlineBuffer, characterIndex));
}

- (void)removeCharactersInString:(NSString *)string;
{
    CFStringInlineBuffer inlineBuffer;
    unsigned int characterIndex, length;
    
    length = CFStringGetLength((CFStringRef)string);
    CFStringInitInlineBuffer((CFStringRef)string, &inlineBuffer, CFRangeMake(0, length));
    for (characterIndex = 0; characterIndex < length; characterIndex++)
        OFCharacterSetRemoveCharacter(self, CFStringGetCharacterFromInlineBuffer(&inlineBuffer, characterIndex));
}

//

- (void)addAllCharacters;
{
    memset(bitmapRep, 0xff, OFCharacterSetBitmapRepLength);
}
- (void)removeAllCharacters;
{
    bzero(bitmapRep, OFCharacterSetBitmapRepLength);
}

- (void)invert;
{
    unsigned int maskIndex;
    
    maskIndex = OFCharacterSetBitmapRepLength;
    while (maskIndex--)
        bitmapRep[maskIndex] = ~bitmapRep[maskIndex];
}

// NSCopying protocol

- copy;
{
    OFCharacterSet *copy;

    copy = [[isa alloc] init];
    memcpy(copy->bitmapRep, bitmapRep, OFCharacterSetBitmapRepLength);
    return copy;
}




@end

@implementation OFCharacterSet (Private)
@end
