// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniFoundation/OFPreference.h,v 1.1 2001/02/18 20:59:09 bungi Exp $

#import <Foundation/NSObject.h>
#import <OmniFoundation/OFSimpleLock.h>

@class NSString, NSArray, NSDictionary, NSData;

@interface OFPreference : NSObject
{
    NSString         *_key;
    OFSimpleLockType  _lock;
    id                _value;
}

// API

+ (OFPreference *) preferenceForKey: (NSString *) key;

- (NSString *) key;

- (BOOL) hasNonDefaultValue;
- (void) restoreDefaultValue;

- (id) objectValue;
- (NSString *) stringValue;
- (NSArray *) arrayValue;
- (NSDictionary *) dictionaryValue;
- (NSData *) dataValue;
- (int) integerValue;
- (float) floatValue;
- (BOOL) boolValue;

- (void) setObjectValue: (id) value;
- (void) setStringValue: (NSString *) value;
- (void) setArrayValue: (NSArray *) value;
- (void) setDictionaryValue: (NSDictionary *) value;
- (void) setDataValue: (NSData *) value;
- (void) setIntegerValue: (int) value;
- (void) setFloatValue: (float) value;
- (void) setBoolValue: (BOOL) value;

@end
