// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniFoundation/NSCalendarDate-OFExtensions.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniFoundation/OpenStepExtensions.subproj/NSCalendarDate-OFExtensions.m,v 1.12 2001/03/21 00:52:02 nygard Exp $")

@implementation NSCalendarDate (OFExtensions)

+ (NSCalendarDate *)unixReferenceDate;
{
    static NSCalendarDate *unixReferenceDate = nil;
    const long zero = 0;

    if (unixReferenceDate == nil) {
        unixReferenceDate = [[NSCalendarDate dateWithString:[NSString stringWithCString:ctime(&zero)] calendarFormat:@"%a %b %d %H:%M:%S %Y\n"] retain];
    }
    return unixReferenceDate;
}

- (void)setToUnixDateFormat;
{
    if ([self yearOfCommonEra] == [(NSCalendarDate *)[NSCalendarDate date] yearOfCommonEra])
	[self setCalendarFormat:@"%b %d %H:%M"];
    else
	[self setCalendarFormat:@"%b %d %Y"];
}

- initWithTime_t:(int)time;
{
    NSCalendarDate *date;

    date = (id)[self initWithTimeInterval:time sinceDate:[isa unixReferenceDate]];
    [date setToUnixDateFormat];
    return date;
}

// We're going with Noon instead of midnight, since it's a bit more tolerant of
// time zone switching. (When you're adding days.)

- (NSCalendarDate *)safeReferenceDate;
{
    int year, month, day;

    year = [self yearOfCommonEra];
    month = [self monthOfYear];
    day = [self dayOfMonth];

    return [NSCalendarDate dateWithYear:year month:month day:day
                           hour:12 minute:0 second:0 timeZone:[NSTimeZone localTimeZone]];
}

- (NSCalendarDate *)firstDayOfMonth;
{
    NSCalendarDate *firstDay;

    firstDay = [[NSCalendarDate alloc] initWithYear:[self yearOfCommonEra]
                                       month:[self monthOfYear]
                                       day:1
                                       hour:12
                                       minute:0
                                       second:0
                                       timeZone:nil];
    return [firstDay autorelease];
}

- (int)numberOfDaysInMonth;
{
    NSCalendarDate *date;

    date = [[self firstDayOfMonth] dateByAddingYears:0 months:1 days:-1 hours:0 minutes:0 seconds:0];

    return [date dayOfMonth];
}

@end
