// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniFoundation/DataStructures.subproj/OFMultiValueDictionary.h,v 1.13 2001/03/29 09:13:54 krevis Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray;

@interface OFMultiValueDictionary : OFObject <NSMutableCopying>
{
    NSMutableDictionary *dictionary;
}

- initWithCaseInsensitiveKeys: (BOOL) caseInsensitivity;

- (NSArray *)arrayForKey:(NSString *)aKey;
- (id)firstObjectForKey:(NSString *)aKey;
- (id)lastObjectForKey:(NSString *)aKey;
- (void)addObject:(id)anObject forKey:(NSString *)aKey;
- (void)removeObject:(id)anObject forKey:(NSString *)aKey;
- (NSEnumerator *)keyEnumerator;
- (NSArray *)allKeys;
- (NSArray *)allValues;

- (NSMutableDictionary *)dictionary;

@end
