// Copyright 2000-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFResourceFork.h"

#import <Carbon/Carbon.h>
#import <CoreFoundation/CoreFoundation.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "OFResource.h"
#import "NSString-OFExtensions.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/CoreServicesExtensions/OFResourceFork.m,v 1.2 2002/03/09 01:54:00 kc Exp $")


@implementation OFResourceFork

- initWithContentsOfFile: (NSString *) aPath forkType: (OFForkType) aForkType;
{
    CFURLRef url;
    Boolean success;
    OSErr err;
    FSRef fsRef;
    HFSUniStr255 forkName;
    
    path = [aPath copy];

    url = CFURLCreateWithFileSystemPath(kCFAllocatorDefault, (CFStringRef)path, kCFURLPOSIXPathStyle, false);
    success = CFURLGetFSRef(url, &fsRef);
    CFRelease(url);
    if (!success) {
        [self release];
        [NSException raise: NSInvalidArgumentException format: @"Unable to get a FSRef from the path %@.", aPath];
    }
    
    if (aForkType == OFDataForkType) {
        err = FSGetDataForkName(&forkName);
    } else if (aForkType == OFResourceForkType) {
        err = FSGetResourceForkName(&forkName);
    } else {
        err = noErr;
        [self release];
        [NSException raise: NSInvalidArgumentException format: @"Invalid fork type %d.", aForkType];
    }
    
    if (err != noErr) {
        [self release];
        [NSException raise: NSInvalidArgumentException format: @"Unable to get fork name for fork type %d (err = %d)", aForkType, err];
    }
    
    err = FSOpenResourceFile(&fsRef, forkName.length, forkName.unicode, fsCurPerm, &refNum);
    if (err != noErr) {
        [self release];
        [NSException raise: NSInvalidArgumentException format: @"Unable to open resource fork from fork type %d in file %@ (err = %d).", aForkType, aPath, err];
    }
    
    return self;
}

- initWithContentsOfFile: (NSString *) aPath;
{
    return [self initWithContentsOfFile: aPath forkType: OFResourceForkType];
}

- (void) dealloc;
{
    [path release];
    CloseResFile(refNum);
    [super dealloc];
}

- (NSString *) path;
{
    return path;
}

- (NSArray *) stringsForResourceWithIdentifier: (ResID) resourceIdentifier;
{
    Handle resourceHandle;
    NSMutableArray *strings = nil;
        
    resourceHandle = Get1Resource(FOUR_CHAR_CODE('STR#'), resourceIdentifier);
    if (resourceHandle) {
        unsigned char *str;
        short stringCount;

        strings = [NSMutableArray array];
        stringCount = *(short *)*resourceHandle;
        str = ((char *)*resourceHandle) + sizeof(short);
        while (stringCount--) {
            NSString *string;
            
            string = [[NSString alloc] initWithCString: &str[1] length: *str];
            [strings addObject: string];
            [string release];

            str = str + *str + 1;
        }

        //CloseResFile tosses all the handles gotten from the resID passed to it.
        //DisposeHandle(resourceHandle);
    }
    
    return strings;
}

- (short) countForResourceType: (ResType) resourceType;
{
    short count;
    
    count = Count1Resources(resourceType);
    
    return count;
}

- (NSData *) dataForResourceType: (ResType) resourceType atIndex: (short) index;
{
    Handle resourceHandle;
    NSData *data = nil;
        
    // Get the resource, converting for 1-based indexing
    resourceHandle = Get1IndResource(resourceType, index+1);
    
    if (resourceHandle) {
        Size size;
        
        HLock(resourceHandle);
        size = GetHandleSize(resourceHandle);
        data = [NSData dataWithBytes: *resourceHandle length: size];
        HUnlock(resourceHandle);
        
        //CloseResFile tosses all the handles gotten from the resID passed to it.
        //DisposeHandle(resourceHandle);
    }
    
    return data;
}

- (NSArray *)resourceTypes;
{
    NSMutableArray *types;
    short numTypes;
    short typeIndex;
    ResType aType;
    NSString *typeString;
    
    types = [[[NSMutableArray alloc] init] autorelease];
    
    numTypes = CountTypes();
    for (typeIndex = 1; typeIndex <= numTypes; typeIndex++) {
        GetIndType(&aType, typeIndex);
        typeString = [NSString stringWithFourCharCode:aType];
        [types addObject:typeString];
    }
    
    return types;
}

- (short)numberOfResourcesOfType:(NSString *)resourceType;
{
    OBASSERT(resourceType != nil);
    OBASSERT([resourceType length] >= 4);
    
    return CountResources([resourceType fourCharCodeValue]);
}

- (NSArray *)resourcesOfType:(NSString *)resourceType;
{
    NSMutableArray *resources;
    short numResources;
    short index;
    Handle aResource;
    
    OBASSERT(resourceType != nil);
    OBASSERT([resourceType length] >= 4);
    
    resources = [[[NSMutableArray alloc] init] autorelease];
    
    numResources = CountResources([resourceType fourCharCodeValue]);
    for (index = 1; index <= numResources; index++) {
        OFResource *resource;
        
        aResource = GetIndResource([resourceType fourCharCodeValue], index);
        if (!aResource)
            continue;
        
        resource = [[OFResource alloc] initInResourceFork:self withHandle:aResource];
        [resources addObject:resource];
        [resource release];
    }
    
    return resources;
}

@end
