// Copyright 2000-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFTimeSpanFormatter.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "NSObject-OFExtensions.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/Formatters.subproj/OFTimeSpanFormatter.m,v 1.8 2002/03/09 01:54:01 kc Exp $")

@implementation OFTimeSpanFormatter

- (void)setUseVerboseFormat:(BOOL)shouldUseVerbose;
{
    shouldUseVerboseFormat = shouldUseVerbose;
}

- (BOOL)shouldUseVerboseFormat;
{
    return shouldUseVerboseFormat;
}

- (NSString *)stringForObjectValue:(id)object;
{
    if ([object isKindOfClass:[NSNumber class]]) {
        NSMutableArray *components;
        int intValue;
        float floatValue;
        unsigned int part;

        components = [NSMutableArray array];
        intValue = [(NSDecimalNumber *)object intValue];
        floatValue = [(NSDecimalNumber *)object floatValue];
        floatValue -= (float)intValue;

        if ((part = intValue / 40)) {
            if (shouldUseVerboseFormat) {
                if (part > 1.0)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d weeks", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span), part]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d week", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span singular), part]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%dw", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span abbreviated), part]];

            intValue -= part*40;
        }
        if ((part = intValue / 8)) {
            if (shouldUseVerboseFormat) {
                if (part > 1.0)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d days", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span), part]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d day", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span singular), part]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%dd", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span abbreviated), part]];

            intValue -= part*8;
        }
        if (floatValue) {
            floatValue += (float)intValue;
            if (shouldUseVerboseFormat) {
                if (floatValue > 1.0)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%1.1f hours", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span), floatValue]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%1.1f hour", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span singular), floatValue]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%1.1fh", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span abbreviated), floatValue]];
        } else if (intValue || ![components count]) {
            if (shouldUseVerboseFormat) {
                if (intValue > 1)
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d hours", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span), intValue]];
                else
                    [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%d hour", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span singular), intValue]];
            } else
                [components addObject:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"%dh", @"OmniFoundation", [OFTimeSpanFormatter bundle], time span formatter span abbreviated), intValue]];
        }
        return [components componentsJoinedByString:@" "];
    } else
        return nil;
}

- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error;
{
    BOOL gotAnythingValid = NO;
    float number, hours = 0.0;
    NSScanner *scanner;
    NSCharacterSet *whitespaceCharacterSet;
    
    if (![string length]) {
        *obj = nil;
        return YES;
    }

    whitespaceCharacterSet = [NSCharacterSet whitespaceCharacterSet];
    scanner = [NSScanner scannerWithString:string];
    while(1) {
        // Eat whitespace
        [scanner scanCharactersFromSet:whitespaceCharacterSet intoString:(NSString **)0];
        
        if (![scanner scanFloat:&number]) {
            if (gotAnythingValid)
                break;
            if (error)
                *error = NSLocalizedStringFromTableInBundle(@"Invalid time span format", @"OmniFoundation", [OFTimeSpanFormatter bundle], formatter input error);
            return NO;
        }
        if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"m", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter lowercase first character in months) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"M", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter uppercase first character in months) intoString:NULL]) {
            number *= 160.0;
        } else if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"w", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter lowercase first character in weeks) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"W", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter uppercase first character in weeks) intoString:NULL]) {
            number *= 40.0;
        } else if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"d", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter lowercase first character in days) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"D", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter uppercase first character in days) intoString:NULL]) {
            number *= 8.0;
        } else if ([scanner scanString:NSLocalizedStringFromTableInBundle(@"h", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter lowercase first character in hours) intoString:NULL] || [scanner scanString:NSLocalizedStringFromTableInBundle(@"H", @"OmniFoundation", [OFTimeSpanFormatter bundle], timespan formatter uppercase first character in hours) intoString:NULL]) {
        }
        hours += number;
        gotAnythingValid = YES;
    }

    *obj = [NSDecimalNumber numberWithFloat:hours];
    return YES;
}

@end
