// Copyright 2001-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniFoundation/OFSoftwareUpdateChecker.h,v 1.7 2002/03/09 01:54:00 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OFScheduledEvent;

extern NSString *OFSoftwareUpdateExceptionName;
extern NSString *OSUPreferencesChangedNotificationName;

@interface OFSoftwareUpdateChecker : OFObject
{
    OFScheduledEvent *automaticUpdateEvent;
    
    id checkTarget;
    SEL checkAction;
    
    struct {
        unsigned int updateInProgress: 2;  // may be 0, 1, or 2
        unsigned int shouldCheckAutomatically: 1;
    } flags;

    struct _softwareUpdatePostponementState *postpone;
}

- initWithTarget:anObject action:(SEL)anAction;
- (BOOL)checkSynchronously;

@end
