// Copyright 2008 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// <http://www.omnigroup.com/developer/sourcecode/sourcelicense/>.
//
// $Header: svn+ssh://source.omnigroup.com/Source/svn/Omni/tags/OmniSourceRelease/2008-09-07/OmniGroup/Frameworks/OmniDataObjects/NSPredicate-ODOExtensions.h 104581 2008-09-06 21:18:23Z kc $

#import <OmniDataObjects/ODOPredicate.h> // Get the #defines for NSPredicate or ODOPredicate and friends

// iPhone doesn't have NSPredicate and I don't want to re-implement the parsing in the 'format' routines.  Here are some utilities to create the kinds of predicates we need.

extern NSPredicate *ODOKeyPathEqualToValuePredicate(NSString *keyPath, id value);
extern NSPredicate *ODOKeyPathCompareToValuePredicate(NSString *keyPath, NSPredicateOperatorType op, id value);
extern NSPredicate *ODOKeyPathTruePredicate(NSString *keyPath);
extern NSPredicate *ODOKeyPathFalsePredicate(NSString *keyPath);

extern NSPredicate *ODOMakeCompoundPredicate(NSCompoundPredicateType type, NSPredicate *firstPredicate, va_list args);
extern NSPredicate *ODOAndPredicates(NSPredicate *firstPredicate, ...);
extern NSPredicate *ODOOrPredicates(NSPredicate *firstPredicate, ...);
