// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OHFontStyle.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHTextBuilder.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Building.subproj/OHFontStyle.m,v 1.4 2000/03/25 06:37:02 wjs Exp $")

@implementation OHFontStyle

// Init and dealloc

- initFontFaceName:(NSString *)newFontFaceName textColor:(NSColor *)newTextColor fontSizeIndex:(unsigned int)newFontSizeIndex;
{
    [super init];

    fontFaceName = [newFontFaceName retain];
    textColor = [newTextColor retain];
    fontSizeIndex = newFontSizeIndex;

    return self;
}

- (void)dealloc;
{
    [fontFaceName release];
    [textColor release];
    [super dealloc];
}


// API

- (void)restoreFontStyleInTextBuilder:(OHTextBuilder *)textBuilder;
{
    [textBuilder setFontFaceNameOverride:fontFaceName];
    [textBuilder setTextColorOverride:textColor];
    [textBuilder setFontSizeIndex:fontSizeIndex];
}

@end
