// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OHTextBuilderDefaultsHolder.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Building.subproj/OHTextBuilderDefaultsHolder.m,v 1.5 2000/02/29 09:11:49 wjs Exp $")

@interface OHTextBuilderDefaultsHolder (Private)
+ (void)defaultsDidChange:(NSNotification *)notification;
@end

@implementation OHTextBuilderDefaultsHolder

static OHTextBuilderDefaultsHolder *textBuilderDefaults = nil;
static NSLock *classLock;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    classLock = [[NSLock alloc] init];
    [self defaultsDidChange:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(defaultsDidChange:) name:NSUserDefaultsDidChangeNotification object:nil];
}


+ (OHTextBuilderDefaultsHolder *)defaultsHolder;
{
    OHTextBuilderDefaultsHolder *currentDefaultsHolder;

    [classLock lock]; {
        currentDefaultsHolder = [[textBuilderDefaults retain] autorelease];
    } [classLock unlock];

    return currentDefaultsHolder;
}


- init;
{
    NSUserDefaults *defaults;
    
    [super init];

    defaults = [NSUserDefaults standardUserDefaults];
    normalFontName = [[defaults stringForKey:@"OHNormalFont"] retain];
    titleFontName = [[defaults stringForKey:@"OHTitleFont"] retain];
    fixedPitchFontName = [[defaults stringForKey:@"OHFixedPitchFont"] retain];

    normalFontSize = [defaults floatForKey:@"OHNormalFontSize"];
    titleFontSize = [defaults floatForKey:@"OHTitleFontSize"];
    fixedPitchFontSize = [defaults floatForKey:@"OHFixedPitchFontSize"];

    flags.underlineAnchors = [defaults boolForKey:@"OHUnderlineAnchors"];
    flags.incrementalDisplay = [defaults boolForKey:@"OHIncrementalDisplay"];
    
    // NOT USED yet -- move to OmniTextContainer when created
    delayFlushTime = [defaults floatForKey:@"OHWaitForImagesTime"];

    return self;
}

- (void)dealloc;
{
    [normalFontName release];
    [titleFontName release];
    [fixedPitchFontName release];
    
    [super dealloc];
}

@end

@implementation OHTextBuilderDefaultsHolder (Private)

+ (void)defaultsDidChange:(NSNotification *)notification;
{
    [classLock lock]; {
        [textBuilderDefaults release];
        textBuilderDefaults = [[OHTextBuilderDefaultsHolder alloc] init];
    } [classLock unlock];
}

@end


