// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OWSGMLDTD-OHHTMLDTD.h>

#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Building.subproj/OWSGMLDTD-OHHTMLDTD.m,v 1.5 2000/03/25 06:37:03 wjs Exp $")

@implementation OWSGMLDTD (OHHTMLDTD)

+ (OWSGMLDTD *)OHHTMLDTD;
{
    static OWSGMLDTD *OHHTMLDTD = nil;
    OWContentType *html, *sgml;

    if (OHHTMLDTD)
	return OHHTMLDTD;

    html = [OWContentType contentTypeForString:@"text/html"];
    sgml = [OWContentType contentTypeForString:@"ObjectStream/sgml"];

    [OWHTMLToSGMLObjects registerProcessorClass:[OWHTMLToSGMLObjects class] fromContentType:html toContentType:sgml cost:1.0];

    OHHTMLDTD = [[OWSGMLDTD registeredDTDForSourceContentType:html destinationContentType:sgml] retain];

    return OHHTMLDTD;
}

@end

@implementation OWSGMLProcessor (OHHTMLDTD)

+ (OWSGMLDTD *)dtd;
{
    return [OWSGMLDTD OHHTMLDTD];
}

@end
