// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHAppletCell.h,v 1.11 2000/03/25 06:37:04 wjs Exp $

#import <OmniHTML/OHViewCell.h>

@class NSMutableSet, NSLock, NSDictionary, NSMutableDictionary;
@class OWAddress;
@class OWDocText, OHHTMLDocument;

typedef enum {
    OHAppletStatusUnloaded, OHAppletStatusLoading, OHAppletStatusReady, OHAppletStatusRunning, OHAppletStatusStopped, OHAppletStatusError
} OHAppletStatus;

#import <AppKit/NSNibDeclarations.h> // For IBAction
#import <OWF/OWTargetProtocol.h>
#import <OmniHTML/OHAppletControllerProtocol.h>

@interface OHAppletCell : OHViewCell <OWTarget>
{
    OHHTMLDocument *nonretainedHTMLDocument;
    NSString *appletClassName;
    NSString *archive;
    OWAddress *codeBaseAddress;
    NSMutableDictionary *parameters;
    NSString *cellName;

    OHAppletStatus status;

    id <OHAppletController> appletController;
}

- initWithCode:(NSString *)aClassName archive:(NSString *)anArchive codeBaseAddress:(OWAddress *)anAddress referringAddress:(OWAddress *)aReferringAddress htmlDocument:(OHHTMLDocument *)aDocument;
    // Information from the <applet> tag

- (void)addParameter:(NSString *)name value:(NSString *)value;
- (void)addParameterDictionary:(NSDictionary *)dictionary;
    // Information from subsequent <param> tags

- (OWAddress *)codeBaseAddress;
- (NSString *)archive;
- (OHHTMLDocument *)document;
- (NSDictionary *)parameters;

- (NSString *)name;
- (void)setName:(NSString *)appletName;

- (id <OHAppletController>)appletController;

// Actions

- (IBAction)start:(id)sender;
- (IBAction)stop:(id)sender;

@end
