// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHBasicCell.h,v 1.21 2000/04/06 02:04:18 wjs Exp $

#ifndef OHBasicCell_h
#define OHBasicCell_h

#import <AppKit/NSTextAttachment.h>

#import <OmniFoundation/OFObject.h>

#import <OmniHTML/OHWidthRange.h>

@class NSFont;
@class OHHTMLLink, OHHTMLAnchor, OHHTMLOwner, OHHTMLView;
@class OWScriptEventHandlerHolder;

typedef enum {
    OHCellAlignVerticalTop, // "top"
    OHCellAlignVerticalMiddle, // "middle" or "center"
    OHCellAlignVerticalBaseline, // "bottom" or "baseline"
    OHCellAlignVerticalTextTop, // "texttop"
    OHCellAlignVerticalAbsoluteMiddle, // "absmiddle"
    OHCellAlignVerticalAbsoluteBottom, // "absbottom"
    OHCellAlignMarginalLeft, // "left"
    OHCellAlignMarginalRight, // "right"
    OHCellAlignNotMarginal, // internal use
    // TODO: BleedLeft, BleedRight  (Wil 3/24/98: What the heck are those?)
} OHCellAlignment;


@interface OHBasicCell : OFObject <NSTextAttachmentCell>
{
    OHHTMLOwner *nonretainedHTMLOwner;
    unsigned int characterPosition;
    OHCellAlignment alignment;
    NSPoint baselineOffset;
    NSFont *font;

    NSSize requestedSize; // HTML specified size, if any.  0 if unspecified.
    NSSize insetSize; // Amount of space to leave around cell, not included in requestedSize.
    NSRect cellFrame; // Includes inset, plus any border for subclasses
    
    struct {
        unsigned int requestedWidthIsPercentage:1;
        unsigned int requestedHeightIsPercentage:1;
    } flags;
}

+ (OHCellAlignment)cellAlignmentForAlignmentString:(NSString *)alignmentString;
+ (NSString *)stringForCellAlignment:(OHCellAlignment)anAlignment;

- (void)setAlignment:(OHCellAlignment)newAlignment;
- (void)setAlignmentString:(NSString *)alignmentString;
- (void)setBaselineOffset:(NSPoint)newBaselineOffset;
- (NSPoint)baselineOffset;
    // MAKE SURE TO CALL THIS INSTEAD OF -cellBaselineOffset, as the latter return 0,0 to fool the NSText system.
- (void)setOrigin:(NSPoint)newOrigin;
- (void)setLayoutBounds:(NSRect)bounds;
    // Tells the cell the available area in which to lay out.

- (void)setInsetSize:(NSSize)newInsetSize;
- (void)setInsetSizeWidthString:(NSString *)widthString heightString:(NSString *)heightString defaultWidth:(float)defaultWidth;
- (void)setRequestedSize:(NSSize)newRequestedSize requestedWidthIsPercentage:(BOOL)requestedWidthIsPercentage requestedHeightIsPercentage:(BOOL)requestedHeightIsPercentage;
- (void)setRequestedSizeWidthString:(NSString *)widthString heightString:(NSString *)heightString;

- (NSSize)contentSizeInLayoutBounds:(NSRect)layoutBounds;
- (NSSize)totalSizeInLayoutBounds:(NSRect)layoutBounds;
- (NSSize)naturalSize; // For images, the original image size
- (BOOL)shouldScaleContentSizeBasedOnNaturalSize;
- (NSSize)insetSize;
- (NSRect)contentFrame;
- (NSRect)cellFrame;
    // This returns the size of the cell.  (The -cellSize will be ignored by our text view.)
- (OHWidthRange)widthRange;

// Layout
- (OHCellAlignment)verticalAlignment;
- (OHCellAlignment)marginalAlignment;
- (BOOL)isMarginalCell;
    // Returns whether the cell's alignment indicates that the cell is a marginal cell (which it is if it's OHCellAlignLeft or OHCellAlignRight).

- (NSRect)cutFromLayoutBounds:(NSRect)bounds;

- (int)baselineOffsetChangeToAlignText;

// Drawing
- (void)drawRect:(NSRect)drawRect inHTMLView:(OHHTMLView *)htmlView;

// Setup from OHTextBuilder
- (void)setCharacterPosition:(unsigned int)position htmlOwner:(OHHTMLOwner *)anHTMLOwner;
- (unsigned int)characterPosition;
- (OHHTMLOwner *)htmlOwner;

- (void)nullifyHTMLOwner;

- (void)setFont:(NSFont *)font;
- (NSFont *)font;

- (BOOL)trackMouse:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
    // Returns YES if the cell handled the event, NO if the view should do its normal handling for that event.
- (void)userClicked:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
    // Most often called by trackMouse, can be called directly if you KNOW you don't want to drag (like, in a right-mouse-down)
- (OHHTMLAnchor *)link;
- (BOOL)hasLinks;
- (OHHTMLLink *)linkAtPoint:(NSPoint)point; /* point is in view's coords */
- (OWScriptEventHandlerHolder *)eventHandlers;

- (OHHTMLView *)containingView;
- (void)relayoutCell;
    // Calls -relayoutCell: on our containing view (call from any thread)
- (void)redisplayCell;
    // Calls -redisplayCell: on our containing view (call from any thread)

// NSTextAttachment pretend methods
- (NSFileWrapper *)fileWrapper;
- (id <NSTextAttachmentCell>)attachmentCell;

@end

@interface OHBasicCell (SubclassesOnly)
- (NSColor *)missingInteriorFillColor;
- (void)drawMissingInteriorWithFrame:(NSRect)contentFrame inView:(OHHTMLView *)aView;
- (void)drawInteriorWithFrame:(NSRect)contentFrame inView:(OHHTMLView *)aView;
- (void)drawImage:(NSImage *)anImage withFrame:(NSRect)contentFrame inView:(OHHTMLView *)aView;
@end

static inline NSSize OHInsetSize(NSSize size, float insetWidth, float insetHeight)
{
    size.width -= insetWidth + insetWidth;
    size.height -= insetHeight + insetHeight;
    return size;
}

#endif
