// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHBreak.h,v 1.3 2000/01/20 00:27:47 kc Exp $

#import <OmniFoundation/OFObject.h>

typedef enum {
    OHBreakClearLeftSide = 1,
    OHBreakClearRightSide = 2,
    OHBreakClearBothSides = 3,
} OHBreakType;

@interface OHBreak : OFObject
{
    OHBreakType type;
    unsigned int characterPosition;
}

+ (OHBreak *)breakOfType:(OHBreakType)aType;

- initWithType:(OHBreakType)aType;
- (OHBreakType)type;

- (void)setCharacterPosition:(unsigned int)position;
- (unsigned int)characterPosition;


@end
