// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHBreak.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHBreak.m,v 1.3 2000/03/25 06:37:04 wjs Exp $")

@interface OHBreak (Private)
- initWithType:(OHBreakType)aType;
@end

@implementation OHBreak

+ (OHBreak *)breakOfType:(OHBreakType)aType;
{
    return [[[self alloc] initWithType:aType] autorelease];
}

- initWithType:(OHBreakType)aType;
{
    if (![super init])
	return nil;

    type = aType;

    return self;
}


//

- (OHBreakType)type;
{
    return type;
}

- (void)setCharacterPosition:(unsigned int)position;
{
    characterPosition = position;
}
- (unsigned int)characterPosition;
{
    return characterPosition;
}



@end
