// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHHorizontalRule.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>

#import <OmniHTML/OHHTMLOwner.h>
#import <OmniHTML/OHHTMLView.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHHorizontalRule.m,v 1.14 2000/03/25 06:37:04 wjs Exp $")

#define LAYOUT_IE_METHOD 1

const float MINIMUM_RULE_VERTICAL_PADDING = 1.0;
const float MINIMUM_RULE_HEIGHT_WITHOUT_PADDING = 10.0;

@implementation OHHorizontalRule

- initWithNoShade:(BOOL)noShading;
{
    if (![super init])
	return nil;

    insetSize.height = MINIMUM_RULE_VERTICAL_PADDING;
    horizontalRuleFlags.noShade = noShading;

    return self;
}


// OHBasicCell subclass

- (void)setRequestedSize:(NSSize)newRequestedSize requestedWidthIsPercentage:(BOOL)requestedWidthIsPercentage requestedHeightIsPercentage:(BOOL)requestedHeightIsPercentage;
{
    if (newRequestedSize.height < 1.0)
        newRequestedSize.height = 1.0;
    if (newRequestedSize.width < 1.0)
        newRequestedSize.width = 1.0;
    [super setRequestedSize:newRequestedSize requestedWidthIsPercentage:requestedWidthIsPercentage requestedHeightIsPercentage:requestedHeightIsPercentage];
}

- (NSSize)contentSizeInLayoutBounds:(NSRect)layoutBounds;
{
    NSSize contentSize;

    contentSize = [super contentSizeInLayoutBounds:layoutBounds];
#if LAYOUT_IE_METHOD
    // This is the IE 4.0 for Mac way -- HRs always scale down to the view's width, even if they have a bigger specified size.
    contentSize.width = MIN(contentSize.width, NSWidth(layoutBounds));
#endif

    contentSize.height = MAX(MINIMUM_RULE_HEIGHT_WITHOUT_PADDING, requestedSize.height);
    
    return contentSize;
}

- (NSRect)contentFrame;
{
    NSRect contentFrame;

    contentFrame = [super contentFrame];

    if (NSHeight(contentFrame) == requestedSize.height)
        return contentFrame;

    OBASSERT(NSHeight(contentFrame) > requestedSize.height);
    contentFrame.origin.y += floor((NSHeight(contentFrame) - requestedSize.height) / 2.0);
    contentFrame.size.height = requestedSize.height;
    return contentFrame;
}


- (OHWidthRange)widthRange;
{
#if LAYOUT_IE_METHOD
    // This is the IE 4.0 for Mac way -- HRs always scale down to the view's width, even if they have a bigger specified size.
    return OHMakeWidthRange(0, 0);
#else    
    // This is the Netscape 4.0 for Mac way -- HRs always scale down to the view's width, even if they have a bigger specified size.
    if (flags.requestedWidthIsPercentage)
        return OHMakeWidthRange(0, 0);
    else
        return OHMakeWidthRange(width, width);
#endif
}

- (void)drawRect:(NSRect)drawRect inHTMLView:(OHHTMLView *)htmlView;
{
    NSRect contentFrame;

    contentFrame = [self contentFrame];

    if (horizontalRuleFlags.noShade) {
	[[NSColor blackColor] set];
	NSRectFill(contentFrame);
        return;
    }

    if (NSHeight(contentFrame) == 1) {
	[[NSColor blackColor] set];
	NSRectFill(contentFrame);
        return;
    }

#if defined(RHAPSODY) && (OBOperatingSystemMajorVersion > 5)
    if (![[NSGraphicsContext currentContext] isDrawingToScreen]) {
#else
    if (![[NSDPSContext currentContext] isDrawingToScreen]) {
#endif        
        [[NSColor whiteColor] set];
        // Right edge
        NSRectFill(NSMakeRect(NSMaxX(contentFrame) - 1, NSMinY(contentFrame), 1, NSHeight(contentFrame)));
        // Bottom edge
        NSRectFill(NSMakeRect(NSMinX(contentFrame), NSMaxY(contentFrame) - 1, NSWidth(contentFrame), 1));

        [[NSColor blackColor] set];
        // Left edge
        NSRectFill(NSMakeRect(NSMinX(contentFrame), NSMinY(contentFrame), 1, NSHeight(contentFrame)));
        // Top edge
        NSRectFill(NSMakeRect(NSMinX(contentFrame), NSMinY(contentFrame), NSWidth(contentFrame), 1));
        return;
    }

    [[NSColor grayColor] set];

    // Top edge is full width
    NSRectFillUsingOperation(NSMakeRect(NSMinX(contentFrame), NSMinY(contentFrame), NSWidth(contentFrame), 1), NSCompositePlusDarker);
    // Left edge doesn't overdraw top
    NSRectFillUsingOperation(NSMakeRect(NSMinX(contentFrame), NSMinY(contentFrame) + 1, 1, NSHeight(contentFrame) - 1), NSCompositePlusDarker);
    // Bottom edge doesn't overdraw left
    NSRectFillUsingOperation(NSMakeRect(NSMinX(contentFrame) + 1, NSMaxY(contentFrame) - 1, NSWidth(contentFrame) - 1, 1), NSCompositePlusLighter);
    // Right edge doesn't overdraw bottom or top
    NSRectFillUsingOperation(NSMakeRect(NSMaxX(contentFrame) - 1, NSMinY(contentFrame) + 1, 1, NSHeight(contentFrame) - 2), NSCompositePlusLighter);
}

@end

@implementation OHHorizontalRule (Private)

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    [debugDictionary setObject:horizontalRuleFlags.noShade ? @"YES" : @"NO" forKey:@"horizontalRuleFlags.noShade"];

    return debugDictionary;
}

@end
