// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHImageCell.h,v 1.13 2000/04/06 02:04:19 wjs Exp $

#import <OmniHTML/OHBasicCell.h>

@class NSColor, NSFont, NSImage, NSView;
@class OHHTMLAnchor, OHHTMLView;

@interface OHImageCell : OHBasicCell
{
    OHHTMLAnchor *link;
    NSImage *cellImage;
    NSSize naturalSize; // The original image size
    unsigned int borderWidth;
}

- (NSImage *)image;
    // Must be called before any layout, does not schedule layout.
- (void)setImage:(NSImage *)newImage;

- (void)setImageSize:(NSSize)newSize;
- (void)setBorderWidth:(unsigned int)aBorderWidth;
- (unsigned int)borderWidth;
- (NSRect)contentFrameWithoutBorder;

@end

@interface OHImageCell (SubclassesOnly)

- (NSColor *)borderColor;
- (void)startDragFromView:(OHHTMLView *)aView event:(NSEvent *)event;

@end
