// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHImageCell.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

// #import <OmniHTML/OWController.h>
#import <OmniHTML/OHHTMLAnchor.h>
#import <OmniHTML/OHHTMLPageView.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHImageCell.m,v 1.33 2000/04/06 02:04:19 wjs Exp $")

@implementation OHImageCell

// Init and dealloc

- (void)dealloc;
{
    [link removeContainedCell:self];
    [link release];
    [cellImage release];
    [super dealloc];
}


// NSTextAttachment pretend subclass

- (NSFileWrapper *)fileWrapper;
{
    NSFileWrapper *fileWrapper;

    fileWrapper = [[NSFileWrapper alloc] initRegularFileWithContents:[cellImage TIFFRepresentation]];
    [fileWrapper setPreferredFilename:[NSStringFromClass(isa) stringByAppendingString:@".tiff"]];
    return [fileWrapper autorelease];
}


// OHBasicCell subclass

- (NSSize)totalSizeInLayoutBounds:(NSRect)layoutBounds;
{
    // Casting to float before turning negative because an unsigned -n is a huge positive number.
    return OHInsetSize([super totalSizeInLayoutBounds:layoutBounds], -(float)borderWidth, -(float)borderWidth);
}

- (NSSize)naturalSize;
{
    return naturalSize;
}

- (void)drawRect:(NSRect)drawRect inHTMLView:(OHHTMLView *)htmlView;
{
    if (borderWidth) {
        NSRect contentFrame;
    
        contentFrame = [self contentFrame];
        if (NSWidth(contentFrame) < 1.0 || NSHeight(contentFrame) < 1.0)
            return;

	[[self borderColor] set];
	NSFrameRectWithWidth(contentFrame, borderWidth);
    }
    
    [self drawInteriorWithFrame:[self contentFrameWithoutBorder] inView:htmlView];
}

- (BOOL)wantsToTrackMouse;
{
    return YES;
}

- (BOOL)trackMouse:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
{
    BOOL startDrag = NO;
    NSEvent *finalEvent = event;

    switch ([event type]) {
        case NSLeftMouseDown:
            startDrag = [htmlView shouldStartDragFromMouseDownEvent:event dragSlop:20.0 finalEvent:&finalEvent];
            if (startDrag)
                [self startDragFromView:htmlView event:event];
            else
                [self userClicked:finalEvent inHTMLView:htmlView];
            return YES;
        case NSRightMouseDown:
            [self userClicked:event inHTMLView:htmlView];
            [htmlView showContextMenuForMouseEvent:event];
            return YES;
        default:
            return NO;
    }
}

- (OHHTMLAnchor *)link;
{
    return link;
}

- (void)userClicked:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
{
    if (!link || ![link address])
	return;

    [link followFromEvent:event];
}

- (NSColor *)missingInteriorFillColor;
{
    return [NSColor colorWithDeviceRed:0.1 green:0.4 blue:0.5 alpha:0.15];
}

- (void)drawInteriorWithFrame:(NSRect)contentFrame inView:(OHHTMLView *)aView;
{
    [self drawImage:[self image] withFrame:contentFrame inView:aView];
}


//

- (NSImage *)image;
{
    return cellImage;
}

- (void)setImage:(NSImage *)newImage;
{
    if (cellImage != newImage) {
        [cellImage release];
        cellImage = [newImage retain];
    }
    [self setImageSize:[cellImage size]];
}

- (void)setImageSize:(NSSize)newSize;
{
    if (naturalSize.height == newSize.height && naturalSize.width == newSize.width)
	return;
    
    naturalSize = newSize;
    if ((requestedSize.width == 0 || requestedSize.height == 0) // Not overridden by requestedSize
        && (NSWidth(cellFrame) > 0 || NSHeight(cellFrame) > 0)) // Already laid-out once
        [self relayoutCell];
}

- (void)setBorderWidth:(unsigned int)aBorderWidth;
{
    borderWidth = aBorderWidth;
}

- (unsigned int)borderWidth;
{
    return borderWidth;
}

- (NSRect)contentFrameWithoutBorder;
{
    return NSInsetRect([self contentFrame], borderWidth, borderWidth);
}

@end


@implementation OHImageCell (SubclassesOnly)

// Subclass us

- (NSColor *)borderColor;
{
    static NSColor *OHImageCellBorderColor = nil;

    if (!OHImageCellBorderColor) {
        OHImageCellBorderColor = [[[NSUserDefaults standardUserDefaults] colorForKey:@"OHImageCellBorderColor"] retain];
    }

    return link ? [link color] : OHImageCellBorderColor;
}

- (void)startDragFromView:(OHHTMLView *)aView event:(NSEvent *)event;
{
}

@end


@implementation OHImageCell (Private)


- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (link)
	[debugDictionary setObject:link forKey:@"link"];

    return debugDictionary;
}

@end
