// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHImageMapHolder.h,v 1.6 2000/01/20 00:27:48 kc Exp $

#import <OmniFoundation/OFObject.h>
#import <OmniFoundation/OFObject.h>

@class NSArray, NSEvent;
@class OWAddress, OHInlineImageCell, OHHTMLView;
@class OHImageMapShape;

#import <OWF/OWTargetProtocol.h>
#import <Foundation/NSGeometry.h> // For NSPoint

@interface OHImageMapHolder : OFObject <OWTarget>
{
    OHInlineImageCell *nonretainedInlineImage;
    OWAddress *imageMapAddress;

    struct {
        unsigned int pipelineIsFetching:1;
    } flags;
    enum {
	OHImageMap_nothing,
	OHImageMap_following,
	OHImageMap_selecting,
    } actionWhenFetched;
    NSPoint pointClicked;

    NSArray *shapes;
}

- initWithImageMapAddress:(OWAddress  *)anAddress inlineImage:(OHInlineImageCell *)inlineImage;

// API
- (void)setInlineImage:(OHInlineImageCell *)anInlineImage;
- (void)fetch;
- (void)selectAnchorAtPoint:(NSPoint)point;
- (void)followAnchorAtPoint:(NSPoint)point;
- (void)startDragForAnchorAtPoint:(NSPoint)point fromView:(OHHTMLView *)aView event:(NSEvent *)event;
- (OHImageMapShape *)shapeAtPoint:(NSPoint)point;

@end
