// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHInlineImageCell.h,v 1.14 2000/04/04 15:01:10 wjs Exp $

#import <OmniHTML/OHImageCell.h>

@class NSLock;
@class OFInvocation;
@class OWAddress, OHHTMLDocument, OHHTMLOwner, OHImageMapHolder, OWWebPipeline, OWScriptEventHandlerHolder;
@class OIImage;

#import <OWF/OWTargetProtocol.h>
#import <OIF/OIImageObserverProtocol.h>

@interface OHInlineImageCell : OHImageCell <OWTarget, OIImageObserver>
{
    OHHTMLDocument *nonretainedHTMLDocument;
    
    NSString *alternateText;
    NSFont *textFont;
    NSString *name;

    struct {
        unsigned int isMap:1;
        unsigned int suspectedAd:1;
    } inlineFlags;

    enum {
	OHInlineImageCell_primordial,
	OHInlineImageCell_fetching,
	OHInlineImageCell_aborting,
	OHInlineImageCell_fetched,
	OHInlineImageCell_aborted,
	OHInlineImageCell_failedToLoad,
    } inlineImageState;

    OIImage *omniImage;

    OHImageMapHolder *imageMapHolder;

    OWScriptEventHandlerHolder *eventHandlers;
}

+ (OWAddress *)addressForPossiblyInternalIconString:(NSString *)iconKeyString;

- initWithAddress:(OWAddress *)anAddress referringAddress:(OWAddress *)aReferringAddress htmlDocument:(OHHTMLDocument *)htmlDocument;

//

- (OHHTMLDocument *)htmlDocument;

- (void)setLink:(OHHTMLAnchor *)aLink;
- (void)setAlternateText:(NSString *)newAlternateText inFont:(NSFont *)aFont;
- (void)setIsMap:(BOOL)newIsMap;
- (void)setMapAddress:(OWAddress *)anAddress;
- (void)setName:(NSString *)aName;

- (void)resetAddress:(OWAddress *)newAddress referrer:(OWAddress *)aReferringAddress;
- (OWAddress *)address;
- (NSString *)name;
- (void)autofetchIfAppropriate;
- (BOOL)needsFetch;
- (BOOL)isFetching;
- (void)fetch;

- (void)startAnimation;
- (void)stopAnimation;

- (OWScriptEventHandlerHolder *)eventHandlers;

@end


@interface OHInlineImageCell (SubclassesOnly)
- (BOOL)clickActionForEvent:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
- (OWAddress *)addressAtPoint:(NSPoint)point;
- (OWAddress *)addressForEvent:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
- (NSPoint)mapPointForEvent:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
@end
