// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHObjectCell.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>
#import <AppKit/AppKit.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OmniHTML/OHPlugInControllerProtocol.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHObjectCell.m,v 1.9 2000/04/03 11:32:00 wjs Exp $")

@implementation OHObjectCell

static NSMutableDictionary *objectPlugins, *embedPlugins, *typePlugins;
static NSImage *objectImage;
static NSImage *objectErrorImage;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    objectPlugins = [[NSMutableDictionary alloc] init];
    embedPlugins = [[NSMutableDictionary alloc] init];
    typePlugins = [[NSMutableDictionary alloc] init];
    objectImage = [[NSImage imageNamed:@"OHObject" inBundleForClass:self] retain];
    objectErrorImage = [[NSImage imageNamed:@"OHObjectError" inBundleForClass:self] retain];
}

+ (void)registerItemName:(NSString *)itemName bundle:(NSBundle *)bundle description:(NSDictionary *)description;
{
    NSString *key;
    
    [OFBundledClass createBundledClassWithName:itemName bundle:bundle description:description];

    key = [[description objectForKey:@"classID"] lowercaseString];
    if (key)
        [objectPlugins setObject:itemName forKey:key];
    key = [[description objectForKey:@"extension"] lowercaseString];
    if (key)
        [embedPlugins setObject:itemName forKey:key];
    key = [[description objectForKey:@"type"] lowercaseString];
    if (key)
        [typePlugins setObject:itemName forKey:key];
}


- initWithClassID:(NSString *)name baseAddress:(OWAddress *)anAddress htmlDocument:(OHHTMLDocument *)aDocument;
{
    if (![super init])
        return nil;

    appletClassName = [[name lowercaseString] retain];
    parameters = [[NSMutableDictionary alloc] init];
    codeBaseAddress = [anAddress retain];
    nonretainedHTMLDocument = aDocument;
    status = OHAppletStatusUnloaded;

    return self;
}

//

- (IBAction)start:(id)sender;
{
    Class appletClass;
    NSString *type;

    if (appletClassName) {
        appletClass = [OFBundledClass classNamed:[objectPlugins objectForKey:appletClassName]];
    } else if ((type = [parameters objectForKey:@"type"])) {
        appletClass = [OFBundledClass classNamed:[typePlugins objectForKey:type]];        
    } else {
        OWAddress *address;
        NSString *extension;

        address = [codeBaseAddress addressForRelativeString:[parameters objectForKey:@"src"]];
        extension = [[[[address url] path] pathExtension] lowercaseString];
        appletClass = [OFBundledClass classNamed:[embedPlugins objectForKey:extension]];
    }
    if (appletClass)
        appletController = [[appletClass alloc] initInCell:self];
    if (!appletController)
        status = OHAppletStatusError;
}

- (void)plugInReady;
{
    status = OHAppletStatusRunning;
    [self queueSelector:@selector(relayoutCell)];
}

- (NSImage *)statusImage;
{
    switch (status) {
        default:
        case OHAppletStatusUnloaded:
        case OHAppletStatusLoading:
            // TODO: Should probably have more status images
        case OHAppletStatusReady:
        case OHAppletStatusStopped:
            return objectImage;
        case OHAppletStatusRunning:
            if ([self hasContentView])
                return nil;
            [self setupContentView];
            if ([self hasContentView])
                return nil;

            status = OHAppletStatusError;
            // NO BREAK
        case OHAppletStatusError:
            return objectErrorImage;
    }
}

@end
