// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Cells.subproj/OHViewCell.h,v 1.10 2000/03/25 06:37:05 wjs Exp $

#import <OmniHTML/OHBasicCell.h>

@interface OHViewCell : OHBasicCell
{
    struct {
        unsigned int doNotRelayoutWhenContentViewFrameChanges:1;
    } viewCellFlags;
@private
    NSView *_contentView;
    NSSize _contentViewSize;
}

- (BOOL)hasContentView;
    // Returns whether the view cell currently has a content view.  Note that calling -contentView on a cell without a content view triggers an assertion if it can't create one.  (It will try to create one by calling -setupContentView.)

- (NSView *)contentView;
    // Returns the current content view.  NOTE:  Do NOT subclass this to return a different value, use -setContentView: instead.

- (void)setupContentView;
    // Subclass this method to set up the content view.

- (void)setContentView:(NSView *)newContentView;
    // Call this method from -setupContentView.

//

- (void)resetContentViewOrigin;
    // Called internally to position the content view

- (void)resetContentViewSize;
    // Called internally to size the content view

@end

@interface OHViewCell (NextKeyViewSupport)

- (void)_setNextKeyViewCell:(OHViewCell *)nextKeyViewCell;
    // Sets the nextKeyView on the contentView to the view of the nextKeyViewCell.

- (void)setNextKeyViewCell:(OHViewCell *)nextKeyViewCell;
    // subclasses implement if they want to be in the key view loop by calling [self _setNextKeyViewCell:nextKeyViewCell];

@end
