// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <AppKit/AppKit.h>

#import <OmniHTML/OHFileBrowseFormActionButton.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHFormFile.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFileBrowseFormActionButton.m,v 1.3 2000/05/25 01:43:53 kc Exp $")

@implementation OHFileBrowseFormActionButton

- initWithForm:(OHForm *)aForm name:(NSString *)aName formFile:(OHFormFile *)newFormFile;
{
    if (![super initWithForm:aForm name:aName value:@"Browse..."])
        return nil;

    formFile = [newFormFile retain];
    return self;
}

- (void)dealloc;
{
    [formFile release];
    [super dealloc];
}

// OHFormActionButton subclass

- (void)setupButton;
{
    [button setTarget:formFile];
    [button setAction:@selector(findFile)];
}

// OHFormElement protocol (partial)

- (NSString *)type;
{
    return @"InternalButton";
}

@end
