// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHForm.h,v 1.10 2000/05/02 01:04:22 krevis Exp $

#import <OmniFoundation/OFObject.h>
#import <Foundation/NSString.h> // For NSStringEncoding
#import <AppKit/NSNibDeclarations.h> // For IBOutlet, IBAction
#import <OmniHTML/OWScriptResponderProtocol.h>

@class NSMutableArray;
@class OWAddress, OHFormArchive, OHFormInputButton, OHFormText, OHHTMLDocument, OHSubmitFormActionButton, OHViewCell;

#import <OmniHTML/OHFormElementProtocol.h>

@interface OHForm : OFObject
{
    OWAddress *address;
    NSString *encodingType;
    NSMutableArray *elements;
    OHViewCell *firstKeyElement, *lastKeyElement;
    OHSubmitFormActionButton *defaultSubmitButton, *firstSubmitButton, *lastSubmitButton;
    OHHTMLDocument *nonretainedHtmlDocument;
    NSMutableDictionary *selectedRadioButtonsByName;
    NSStringEncoding stringEncoding;
    NSString *formName;
    OWScriptEventHandlerHolder *eventHandlers;
}

- (void)setAddress:(OWAddress *)anAddress;
- (void)setEncodingType:(NSString *)anEncodingType;
- (void)setStringEncoding:(NSStringEncoding)newStringEncoding;
- (void)setName:(NSString *)newName;

- (void)setHTMLDocument:(OHHTMLDocument *)newHTMLDocument;
- (OHHTMLDocument *)htmlDocument;

- (void)addFormElement:(id <OHFormElement>)formElement;
- (OHSubmitFormActionButton *)defaultSubmitButton;
- (void)radioButtonSelected:(OHFormInputButton *)selectedButton;
// Submit and reset can be (and are) called from any thread
- (void)reset;
- (void)submit;
- (void)submitBypassingHandlers;

- (IBAction)reset:(id)sender;
- (IBAction)delayedSubmit:(id)sender;

- (OWAddress *)address;
- (NSString *)encodingType;
- (NSString *)name;
- (NSArray *)elements;
- (OHViewCell *)firstKeyElement;
- (OHViewCell *)lastKeyElement;

- (OWScriptEventHandlerHolder *)eventHandlers;

@end
