// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormActionButton.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHForm.h>
#import <OmniHTML/OWScriptEventHandlerHolder.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormActionButton.m,v 1.12 2000/05/24 03:01:22 kc Exp $")

@implementation OHFormActionButton

//
// Actions

- (IBAction)generateClickEvent:(id)sender;
{
    OWScriptEvent *click;

    click = [[OWScriptEvent alloc] initWithType:OWSE_Click fromEvent:[NSApp currentEvent]];
    [click setTarget:self action:@selector(performAction:)];
    [click setInstigator:self];

    // TODO: efficiency shortcuts here ?
    [click addResponder:eventHandlers];
    // TODO: event capture by parent objects

    [click deliverAsynchronously];
    [click release];
}

- (IBAction)performAction:(id)sender;
{
}

// OHFormButton subclass

- (void)setupButton;
{
    [super setupButton];
    [button setButtonType:NSMomentaryPushButton];
    [button setBezelStyle:NSRoundedBezelStyle];
    [button setImagePosition:NSNoImage];
    [button setBordered:YES];
    [button setTitle:value];
    [button setTarget:self];
    [button setAction:@selector(generateClickEvent:)];
    [self reset];
}

// OHBasicCell subclass

- (int)baselineOffsetChangeToAlignText;
{
    return -16;
}

@end
