// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormButton.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHForm.h>
#import <OmniHTML/OHFormValue.h>
#import <OmniHTML/OWScriptEventHandlerHolder.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormButton.m,v 1.15 2000/03/25 06:37:06 wjs Exp $")

@implementation OHFormButton

- initWithForm:(OHForm *)aForm name:(NSString *)aName value:(NSString *)aValue;
{
    if (![super init])
        return nil;

    /* NB: It's possible for the OHForm to go away but for us to stick around because some other object, like a script, has a reference to us, in which case we'll have a garbage pointer here. Currently this isn't a problem because the only object that keeps a ref to us (JSFormElement) also keeps a ref to our OHForm and releases us before it releases it, but it's a dangerous situation. */

    nonretainedForm = aForm;
    name = [aName retain];
    value = [aValue ? aValue : @"on" retain];
    
    eventHandlers = [[OWScriptEventHandlerHolder alloc] init];

    return self;
}

- (void)dealloc;
{
    [eventHandlers release];
    [button release];
    [name release];
    [value release];
    [super dealloc];
}

// Callbacks to be subclassed

- (void)setupButton;
{
    button = [[NSButton alloc] initWithFrame:NSMakeRect(0.0, 0.0, 10.0, 10.0)];
}

// Aqua doesn't support keyboard focus on non-text elements
#if 0
- (void)setNextKeyViewCell:(OHViewCell *)nextKeyViewCell;
{
    [self _setNextKeyViewCell:nextKeyViewCell];
}
#endif

// OHViewCell subclass

- (void)setupContentView;
{
//    ASSERT_IN_MAIN_THREAD(@"AppKit calls must be from main thread!");
    [self setupButton];
    [button sizeToFit];
    OBASSERT(NSHeight([button frame]) >= 10.0);
    [self setContentView:button];
}

// OHFormElement protocol

- (void)reset;
{
}

- (void)clear;
{
}

- (NSString *)name;
{
    return name;
}

- (NSString *)type;
{
    return @"Button";
}

- (NSArray *)formValues;
{
    return nil;
}

- (NSArray *)defaultFormValues;
{
    return nil;
}

- (void)resetFromFormValues:(NSArray *)values;
{
}

- (OWScriptEventHandlerHolder *)eventHandlers
{
    return eventHandlers;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (button)
	[debugDictionary setObject:button forKey:@"button"];
    if (nonretainedForm)
        [debugDictionary setObject:nonretainedForm forKey:@"nonretainedForm"];
    if (name)
	[debugDictionary setObject:name forKey:@"name"];
    if (value)
	[debugDictionary setObject:value forKey:@"value"];
    [debugDictionary setObject:eventHandlers forKey:@"eventHandlers"];

    return debugDictionary;
}

@end

@implementation NSButton (FixKeyboardUI)

- (void)keyDown:(NSEvent *)theEvent
{
    [[self window] keyDown:theEvent];
}

@end
