// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormElementArchive.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormElementArchive.m,v 1.4 2000/03/25 06:37:06 wjs Exp $")

#import <OmniHTML/OHFormValue.h>

@implementation OHFormElementArchive

// Init and dealloc

- initWithFormElement:(id <OHFormElement>)formElement;
{
    [super init];

    type = [[formElement type] copy];
    formValues = [[formElement formValues] retain];
    
    return self;
}

- initWithPropertyList:plist;
{
    NSDictionary *dictionary;
    NSArray *formValuePlists;
    unsigned int valueIndex, valueCount;
    
    [super init];

    dictionary = plist;
    
    type = [[dictionary objectForKey:@"type"] copy];

    // Reconstitute formValues array
    formValuePlists = [dictionary objectForKey:@"values"];
    valueCount = [formValuePlists count];
    formValues = [[NSMutableArray alloc] initWithCapacity:valueCount];

    for (valueIndex = 0; valueIndex < valueCount; valueIndex++) {
        OHFormValue *formValue;

        formValue = [[OHFormValue alloc] initWithPropertyList:[formValuePlists objectAtIndex:valueIndex]];
        [(NSMutableArray *)formValues addObject:formValue];
        [formValue release];
    }
    
    return self;
}


- (void)dealloc;
{
    [type release];
    [formValues release];
    [super dealloc];
}


// API

- (void)resetFormElement:(id <OHFormElement>)formElement;
{
    if (![[formElement type] isEqualToString:type])
        return;

    [formElement resetFromFormValues:formValues];
}

- propertyList;
{
    NSMutableDictionary *dictionary;
    unsigned int formValueIndex, formValueCount;
    NSMutableArray *formValuePlists;

    dictionary = [NSMutableDictionary dictionary];

    if (type)
        [dictionary setObject:type forKey:@"type"];

    formValueCount = [formValues count];
    formValuePlists = [[NSMutableArray alloc] initWithCapacity:formValueCount];
    for (formValueIndex = 0; formValueIndex < formValueCount; formValueIndex++) {
        OHFormValue *formValue;

        formValue = [formValues objectAtIndex:formValueIndex];
        [formValuePlists addObject:[formValue propertyList]];
    }
    [dictionary setObject:formValuePlists forKey:@"values"];
    [formValuePlists release];

    return dictionary;
}


//

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    [debugDictionary addEntriesFromDictionary:[self propertyList]];
    return debugDictionary;
}

@end
