// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormFile.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHForm.h>
#import <OmniHTML/OHFormValue.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormFile.m,v 1.7 2000/03/25 06:37:06 wjs Exp $")

@implementation OHFormFile

- initWithForm:(OHForm *)aForm name:(NSString *)aName types:(NSString *)fileTypes value:(NSString *)aValue alignment:(int)anAlignment width:(unsigned int)aWidth height:(unsigned int)aHeight maximumLength:(unsigned int)aMaximumLength;
{
    /* ignore the initial value */
    if (![super initWithForm:aForm name:aName value:nil alignment:anAlignment disabled:NO invisibleInput:NO width:aWidth height:aHeight maximumLength:aMaximumLength])
	return nil;
    
    allowableTypes = [fileTypes retain];

    return self;
}

- (void)dealloc;
{
    [allowableTypes release];
    [super dealloc];
}

- (NSView *)setupTextField
{
    NSView *theView = [super setupTextField];

    [textField setEditable:NO];
    [textField setSelectable:YES];

    return theView;
}

- (void)findFile;
{
    NSOpenPanel *openPanel;
    NSString *newFilepath;
    BOOL valueChanged;

//    ASSERT_IN_MAIN_THREAD(@"AppKit calls must only be made from the main thread");
   
    openPanel = [NSOpenPanel openPanel];
    [openPanel setTreatsFilePackagesAsDirectories:YES];
    [openPanel setAllowsMultipleSelection:NO];
    // We're not limiting the file types until we know what an ACCEPT attribute really looks like.
    if ([openPanel runModalForDirectory:@"" file:@""] == NSOKButton) {
        newFilepath = [[openPanel filename] retain];
    } else {
	// The only way the user can clear the field.
        newFilepath = nil;
    }

    [elementStateLock lock];
    if (currentValue == newFilepath ||
        [currentValue isEqual:newFilepath]) {
        [newFilepath release];
        valueChanged = NO;
    } else {
        [currentValue release];
        currentValue = newFilepath;
        valueChanged = YES;
    }
    [self updateUI];
    [elementStateLock unlock];

    if (valueChanged)
        [self userDidChangeValue];
}

- (void)updateUI
{
    [elementStateLock lock];
    if (currentValue)
        [textField setStringValue:[currentValue lastPathComponent]];
    else
        [textField setStringValue:@""];
    [elementStateLock unlock];
}
   
// OHFormElement protocol

- (NSString *)type;
{
    return @"File";
}

- (NSArray *)formValues;
{
    OHFormValue *value = nil;
    
    [elementStateLock lock];

    if (name && currentValue)
        value = [OHFormValue formValueWithName:name
                                 valueFilepath:currentValue];

    [elementStateLock unlock];

    if (value)
        return [NSArray arrayWithObject:value];
    else
        return nil;
}

- (NSArray *)defaultFormValues;
{
    return nil;
}

@end
