// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormHidden.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OmniHTML/OHFormValue.h>
#import <OmniHTML/OWScriptEventHandlerHolder.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormHidden.m,v 1.6 2000/03/25 06:37:06 wjs Exp $")

@implementation OHFormHidden

- initWithName:(NSString *)aName value:(NSString *)aValue;
{
    if (![super init])
	return nil;
    
    name = [aName retain];
    value = [aValue retain];
    eventHandlers = [[OWScriptEventHandlerHolder alloc] init];
    
    return self;
}

- (void)dealloc;
{
    [name release];
    [value release];
    [eventHandlers release];
    [super dealloc];
}

// OHFormElement protocol

- (void)reset;
{
}

- (void)clear;
{
}

- (NSString *)name;
{
    return name;
}

- (NSString *)type;
{
    return @"Hidden";
}

- (NSArray *)formValues;
{
    if (!name)
	return nil;

    return [NSArray arrayWithObject:[OHFormValue formValueWithName:name valueString:value]];
}

- (NSArray *)defaultFormValues;
{
    return [self formValues];
}

- (void)resetFromFormValues:(NSArray *)values;
{
    OHFormValue *formValue;

    if ([values count] != 1)
        return;
    formValue = [values objectAtIndex:0];

    // TODO: This is not strictly threadsafe
    [value release];
    value = [[formValue valueString] retain];
}

/* The Hidden form element doesn't actually have any events, but it needs to be able to store handlers as part of the form element protocol. It's conceivable that hidden elements could generate events of some sort someday. */
- (OWScriptEventHandlerHolder *)eventHandlers
{
    return eventHandlers;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (name)
	[debugDictionary setObject:name forKey:@"name"];
    if (value)
	[debugDictionary setObject:value forKey:@"value"];

    return debugDictionary;
}

@end
