// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormImage.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHForm.h>
#import <OmniHTML/OHFormValue.h>
#import <OmniHTML/OHHTMLPageView.h>
#import <OmniHTML/OWScriptEventHandlerHolder.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormImage.m,v 1.19 2000/04/04 12:39:24 wjs Exp $")

@implementation OHFormImage

// Initialization

- initWithAddress:(OWAddress *)anAddress referringAddress:(OWAddress *)aReferringAddress htmlDocument:(OHHTMLDocument *)htmlDocument;
{
    if (![super initWithAddress:anAddress referringAddress:aReferringAddress htmlDocument:htmlDocument])
	return nil;

    nonretainedForm = nil;
    generatedSubmitCount = NO;
    [self setIsMap:YES];
    
    submitStateLock = [[NSLock allocWithZone:[self zone]] init];

    return self;
}

- (void)dealloc;
{
    [submitStateLock release];
    [super dealloc];
}

// Declared methods

- (void)setForm:(OHForm *)aForm;
{
    if (nonretainedForm == aForm)
	return;
    OBPRECONDITION(nonretainedForm == nil);
    nonretainedForm = aForm;
}

// OHInlineImageCell subclass

- (BOOL)clickActionForEvent:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
{
    [submitStateLock lock];
    submitLocation = [self mapPointForEvent:event inHTMLView:htmlView];
    generatedSubmitCount++;
    [submitStateLock unlock];
    [nonretainedForm delayedSubmit:nil];
    return YES;
}

// OHFormElement protocol

- (void)reset;
{
}

- (void)clear;
{
}

- (NSString *)type;
{
    return @"Image"; // NOT JavaScripty
}

- (NSArray *)formValues;
{
    BOOL shouldIncludeValues;
    NSPoint location;
    // If the submit wasn't caused by us, we don't want to include our (stale) co-ordinates.

    [submitStateLock lock];

    if (generatedSubmitCount == 0)
        shouldIncludeValues = NO;
    else {
        shouldIncludeValues = YES;
        location = submitLocation;
        generatedSubmitCount--;
    }

    [submitStateLock unlock];

    if (!shouldIncludeValues)
        return nil;

    // Mosaic/Netscape Compatibility Note: If the name is zero-length, we leave off the dot.
    // THREAD-SAFETY ALERT:  It turns out +[NSString stringWithFormat:] is not thread-safe when asked to format floating point numbers, so that's why we're casting these values to integers rather than using a format like "%1.0f" (as we used to do).
    if (!name || [name length] == 0) {
	return [NSArray arrayWithObjects:
		[OHFormValue formValueWithName:@"x" valueString:[NSString stringWithFormat:@"%d", (int)location.x]],
		[OHFormValue formValueWithName:@"y" valueString:[NSString stringWithFormat:@"%d", (int)location.y]],
		nil];
    } else {
	return [NSArray arrayWithObjects:
		[OHFormValue formValueWithName:[name stringByAppendingString:@".x"]
                 valueString:[NSString stringWithFormat:@"%d", (int)location.x]],
		[OHFormValue formValueWithName:[name stringByAppendingString:@".y"]
                 valueString:[NSString stringWithFormat:@"%d", (int)location.y]],
		nil];
    }
}

- (NSArray *)defaultFormValues;
{
    // Not applicable, as images only have transient state
    return nil;
}

- (void)resetFromFormValues:(NSArray *)values;
{
    // Not applicable, as images only have transient state
}


// OWTarget protocol

- (NSString *)targetTypeFormatString;
{
    return @"Form %@";
}


// Hackage to shut up compiler
- (NSString *)name;
{ return [super name]; }
- (OWScriptEventHandlerHolder *)eventHandlers;
{ return [super eventHandlers]; }

@end
